/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.memory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.memory.ChatMemoryRepository;
import org.springframework.ai.chat.memory.InMemoryChatMemoryRepository;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.util.Assert;

public final class MessageWindowChatMemory
implements ChatMemory {
    private static final int DEFAULT_MAX_MESSAGES = 20;
    private final ChatMemoryRepository chatMemoryRepository;
    private final int maxMessages;

    private MessageWindowChatMemory(ChatMemoryRepository chatMemoryRepository, int maxMessages) {
        Assert.notNull((Object)chatMemoryRepository, (String)"chatMemoryRepository cannot be null");
        Assert.isTrue((maxMessages > 0 ? 1 : 0) != 0, (String)"maxMessages must be greater than 0");
        this.chatMemoryRepository = chatMemoryRepository;
        this.maxMessages = maxMessages;
    }

    @Override
    public void add(String conversationId, List<Message> messages) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        Assert.notNull(messages, (String)"messages cannot be null");
        Assert.noNullElements(messages, (String)"messages cannot contain null elements");
        List<Message> memoryMessages = this.chatMemoryRepository.findByConversationId(conversationId);
        List<Message> processedMessages = this.process(memoryMessages, messages);
        this.chatMemoryRepository.saveAll(conversationId, processedMessages);
    }

    @Override
    public List<Message> get(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        return this.chatMemoryRepository.findByConversationId(conversationId);
    }

    @Override
    public void clear(String conversationId) {
        Assert.hasText((String)conversationId, (String)"conversationId cannot be null or empty");
        this.chatMemoryRepository.deleteByConversationId(conversationId);
    }

    private List<Message> process(List<Message> memoryMessages, List<Message> newMessages) {
        ArrayList<Message> processedMessages = new ArrayList<Message>();
        HashSet<Message> memoryMessagesSet = new HashSet<Message>(memoryMessages);
        boolean hasNewSystemMessage = newMessages.stream().filter(SystemMessage.class::isInstance).anyMatch(message -> !memoryMessagesSet.contains(message));
        memoryMessages.stream().filter(message -> !hasNewSystemMessage || !(message instanceof SystemMessage)).forEach(processedMessages::add);
        processedMessages.addAll(newMessages);
        if (processedMessages.size() <= this.maxMessages) {
            return processedMessages;
        }
        int messagesToRemove = processedMessages.size() - this.maxMessages;
        ArrayList<Message> trimmedMessages = new ArrayList<Message>();
        int removed = 0;
        for (Message message2 : processedMessages) {
            if (message2 instanceof SystemMessage || removed >= messagesToRemove) {
                trimmedMessages.add(message2);
                continue;
            }
            ++removed;
        }
        return trimmedMessages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ChatMemoryRepository chatMemoryRepository;
        private int maxMessages = 20;

        private Builder() {
        }

        public Builder chatMemoryRepository(ChatMemoryRepository chatMemoryRepository) {
            this.chatMemoryRepository = chatMemoryRepository;
            return this;
        }

        public Builder maxMessages(int maxMessages) {
            this.maxMessages = maxMessages;
            return this;
        }

        public MessageWindowChatMemory build() {
            if (this.chatMemoryRepository == null) {
                this.chatMemoryRepository = new InMemoryChatMemoryRepository();
            }
            return new MessageWindowChatMemory(this.chatMemoryRepository, this.maxMessages);
        }
    }
}

