/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.observation.ObservabilityHelper;
import org.springframework.util.CollectionUtils;

public class ChatClientPromptContentObservationHandler
implements ObservationHandler<ChatClientObservationContext> {
    private static final Logger logger = LoggerFactory.getLogger(ChatClientPromptContentObservationHandler.class);

    public void onStop(ChatClientObservationContext context) {
        logger.debug("Chat Client Prompt Content:\n{}", (Object)ObservabilityHelper.concatenateEntries(this.processPrompt(context)));
    }

    private Map<String, Object> processPrompt(ChatClientObservationContext context) {
        if (CollectionUtils.isEmpty((Collection)context.getRequest().prompt().getInstructions())) {
            return Map.of();
        }
        HashMap<String, Object> messages = new HashMap<String, Object>();
        context.getRequest().prompt().getInstructions().forEach(message -> messages.put(message.getMessageType().getValue(), message.getText()));
        return messages;
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ChatClientObservationContext;
    }
}

