/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.util.ForwardedHeaderUtils;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class SwaggerWelcomeCommon
extends AbstractSwaggerWelcome {
    protected SwaggerWelcomeCommon(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        super(swaggerUiConfig, springDocConfigProperties);
    }

    protected ResponseEntity<Void> redirectToUi(HttpServletRequest request) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, request);
        String sbUrl = swaggerUiConfigParameters.getContextPath() + swaggerUiConfigParameters.getUiRootPath() + this.getSwaggerUiUrl();
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(swaggerUiConfigParameters, sbUrl);
        request.getParameterMap().forEach((arg_0, arg_1) -> ((UriComponentsBuilder)uriBuilder).queryParam(arg_0, arg_1));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).location(uriBuilder.build().encode().toUri())).build();
    }

    protected Map<String, Object> openapiJson(HttpServletRequest request) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, request);
        return swaggerUiConfigParameters.getConfigParameters();
    }

    protected void calculateOauth2RedirectUrl(SwaggerUiConfigParameters swaggerUiConfigParameters, UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl()) || !swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            swaggerUiConfigParameters.setOauth2RedirectUrl(uriComponentsBuilder.path(swaggerUiConfigParameters.getUiRootPath()).path(this.getOauth2RedirectUrl()).build().toString());
        }
    }

    protected abstract void calculateUiRootPath(SwaggerUiConfigParameters var1, StringBuilder ... var2);

    protected void buildFromCurrentContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, HttpServletRequest request) {
        super.init(swaggerUiConfigParameters);
        String servletPath = ServletRequestPathUtils.getServletPathPrefix((HttpServletRequest)request);
        String contextPath = request.getContextPath() + (servletPath != null ? servletPath : "");
        swaggerUiConfigParameters.setContextPath(contextPath);
        URI uri = URI.create(request.getRequestURL().toString());
        HttpHeaders headers = new HttpHeaders();
        for (String name : Collections.list(request.getHeaderNames())) {
            headers.addAll(name, Collections.list(request.getHeaders(name)));
        }
        UriComponentsBuilder uriComponentsBuilder = ForwardedHeaderUtils.adaptFromForwardedHeaders((URI)uri, (HttpHeaders)headers).replacePath(contextPath).replaceQuery(null).fragment(null);
        this.buildConfigUrl(swaggerUiConfigParameters, uriComponentsBuilder);
    }
}

