/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Controller
public class SwaggerUiHome {
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String swaggerUiPath;
    private String basePath = "";

    public SwaggerUiHome(Optional<WebFluxProperties> optionalWebFluxProperties) {
        optionalWebFluxProperties.ifPresent(webFluxProperties -> {
            this.basePath = (String)StringUtils.defaultIfEmpty((CharSequence)webFluxProperties.getBasePath(), (CharSequence)"");
        });
    }

    @GetMapping(value={"/"})
    @Operation(hidden=true)
    public Mono<Void> index(ServerHttpResponse response) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)(this.basePath + this.swaggerUiPath));
        response.setStatusCode((HttpStatusCode)HttpStatus.FOUND);
        response.getHeaders().setLocation(URI.create(uriBuilder.build().encode().toString()));
        return response.setComplete();
    }
}

