/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.core.configuration;

import java.util.List;
import java.util.Optional;
import org.springdoc.core.configuration.SpringDocConfiguration;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.discoverer.SpringDocParameterNameDiscoverer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.core.service.RequestBodyService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.webflux.api.OpenApiActuatorResource;
import org.springdoc.webflux.api.OpenApiWebfluxResource;
import org.springdoc.webflux.core.configuration.MultipleOpenApiSupportConfiguration;
import org.springdoc.webflux.core.providers.ActuatorWebFluxProvider;
import org.springdoc.webflux.core.providers.SpringWebFluxProvider;
import org.springdoc.webflux.core.service.RequestService;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.reactive.WebFluxEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SpringDocWebFluxConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="(${springdoc.use-management-port:false} == false ) and ${springdoc.enable-default-api-docs:true}")
    @Lazy(value=false)
    OpenApiWebfluxResource openApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        return new OpenApiWebfluxResource(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    RequestService requestBuilder(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, Optional<List<ParameterCustomizer>> parameterCustomizers, SpringDocParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        return new RequestService(parameterBuilder, requestBodyService, parameterCustomizers, localSpringDocParameterNameDiscoverer);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    GenericResponseService responseBuilder(OperationService operationService, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils) {
        return new GenericResponseService(operationService, springDocConfigProperties, propertyResolverUtils);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpringWebProvider springWebProvider() {
        return new SpringWebFluxProvider();
    }

    @ConditionalOnClass(value={WebFluxEndpointHandlerMapping.class})
    static class SpringDocWebFluxActuatorConfiguration {
        SpringDocWebFluxActuatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnExpression(value="${springdoc.show-actuator:false} or ${springdoc.use-management-port:false}")
        @Lazy(value=false)
        ActuatorProvider actuatorProvider(ServerProperties serverProperties, SpringDocConfigProperties springDocConfigProperties, Optional<ManagementServerProperties> managementServerProperties, Optional<WebEndpointProperties> webEndpointProperties) {
            return new ActuatorWebFluxProvider(serverProperties, springDocConfigProperties, managementServerProperties, webEndpointProperties);
        }

        @Bean
        @ConditionalOnMissingBean(value={MultipleOpenApiSupportConfiguration.class})
        @ConditionalOnExpression(value="${springdoc.use-management-port:false} and ${springdoc.enable-default-api-docs:true}")
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @Lazy(value=false)
        OpenApiActuatorResource actuatorOpenApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
            return new OpenApiActuatorResource(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
        }
    }
}

