/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.versions;

import java.util.ArrayList;
import org.springdoc.core.versions.SpringDocVersionStrategy;

public class PathVersionStrategy
extends SpringDocVersionStrategy {
    private final int pathSegmentIndex;

    public PathVersionStrategy(int pathSegmentIndex, String defaultVersion) {
        super(defaultVersion);
        this.pathSegmentIndex = pathSegmentIndex;
    }

    public int getPathSegmentIndex() {
        return this.pathSegmentIndex;
    }

    @Override
    public String updateOperationPath(String operationPath, String version) {
        if (operationPath == null || version == null) {
            return operationPath;
        }
        String[] segments = operationPath.split("/");
        ArrayList<String> updatedSegments = new ArrayList<String>();
        int segmentCount = 0;
        for (String segment : segments) {
            if (segment.isEmpty()) continue;
            if (segmentCount == this.pathSegmentIndex) {
                Object newSegment = version;
                if (segment.contains("{")) {
                    int placeholderStart = segment.indexOf(123);
                    String prefix = segment.substring(0, placeholderStart);
                    newSegment = prefix + version;
                }
                updatedSegments.add((String)newSegment);
            } else {
                updatedSegments.add(segment);
            }
            ++segmentCount;
        }
        return "/" + String.join((CharSequence)"/", updatedSegments);
    }
}

