/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.scalar;

import com.scalar.maven.webjar.ScalarProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public abstract class AbstractScalarController {
    protected final ScalarProperties scalarProperties;
    protected final String originalScalarUrl;

    protected AbstractScalarController(ScalarProperties scalarProperties) {
        this.scalarProperties = scalarProperties;
        this.originalScalarUrl = scalarProperties.getUrl();
    }

    protected ResponseEntity<String> getDocs(String requestUrl) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/resources/webjars/scalar/index.html");
        if (inputStream == null) {
            return ResponseEntity.notFound().build();
        }
        String html = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        requestUrl = this.decode(requestUrl);
        String cdnUrl = this.buildJsBundleUrl(requestUrl);
        String injectedHtml = html.replace("__JS_BUNDLE_URL__", cdnUrl).replace("__CONFIGURATION__", "    {\n      url: \"%s\"\n    }\n".formatted(this.buildApiDocsUrl(requestUrl)));
        return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)injectedHtml);
    }

    protected ResponseEntity<byte[]> getScalarJs() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/resources/webjars/scalar/scalar.js");
        if (inputStream == null) {
            return ResponseEntity.notFound().build();
        }
        byte[] jsContent = inputStream.readAllBytes();
        return ResponseEntity.ok().contentType(MediaType.valueOf((String)"application/javascript")).body((Object)jsContent);
    }

    protected String decode(String requestURI) {
        return URLDecoder.decode(requestURI, StandardCharsets.UTF_8);
    }

    protected String buildApiDocsUrl(String requestUrl, String apiDocsPath) {
        Object apiDocsUrl = this.scalarProperties.getUrl();
        if ("https://registry.scalar.com/@scalar/apis/galaxy/latest?format=json".equals(this.originalScalarUrl)) {
            String serverUrl = requestUrl.substring(0, requestUrl.length() - this.scalarProperties.getPath().length());
            apiDocsUrl = serverUrl + apiDocsPath;
        }
        return apiDocsUrl;
    }

    protected String buildJsBundleUrl(String requestUrl, String scalarPath) {
        if ("https://registry.scalar.com/@scalar/apis/galaxy/latest?format=json".equals(this.originalScalarUrl)) {
            String path;
            int firstPathSlash = requestUrl.indexOf(47, requestUrl.indexOf("://") + 3);
            String string = path = firstPathSlash >= 0 ? requestUrl.substring(firstPathSlash) : "/";
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path + "/scalar.js";
        }
        return scalarPath + "/scalar.js";
    }

    protected abstract String buildApiDocsUrl(String var1);

    protected abstract String buildJsBundleUrl(String var1);

    private String buildConfigurationJson() {
        StringBuilder config = new StringBuilder();
        config.append("{");
        config.append("\n  url: \"").append(this.escapeJson(this.scalarProperties.getUrl())).append("\"");
        if (this.scalarProperties.getSources() != null && !this.scalarProperties.getSources().isEmpty()) {
            config.append(",\n  sources: ").append(this.buildSourcesJsonArray(this.scalarProperties.getSources()));
        }
        if (!this.scalarProperties.isShowSidebar()) {
            config.append(",\n  showSidebar: false");
        }
        if (this.scalarProperties.isHideModels()) {
            config.append(",\n  hideModels: true");
        }
        if (this.scalarProperties.isHideTestRequestButton()) {
            config.append(",\n  hideTestRequestButton: true");
        }
        if (this.scalarProperties.isDarkMode()) {
            config.append(",\n  darkMode: true");
        }
        if (this.scalarProperties.isHideDarkModeToggle()) {
            config.append(",\n  hideDarkModeToggle: true");
        }
        if (this.scalarProperties.getCustomCss() != null && !this.scalarProperties.getCustomCss().trim().isEmpty()) {
            config.append(",\n  customCss: \"").append(this.escapeJson(this.scalarProperties.getCustomCss())).append("\"");
        }
        if (this.scalarProperties.getTheme() != null && !"default".equals(this.scalarProperties.getTheme())) {
            config.append(",\n  theme: \"").append(this.escapeJson(this.scalarProperties.getTheme())).append("\"");
        }
        if (this.scalarProperties.getLayout() != null && !"modern".equals(this.scalarProperties.getLayout())) {
            config.append(",\n  layout: \"").append(this.escapeJson(this.scalarProperties.getLayout())).append("\"");
        }
        if (this.scalarProperties.isHideSearch()) {
            config.append(",\n  hideSearch: true");
        }
        if (this.scalarProperties.getDocumentDownloadType() != null && !"both".equals(this.scalarProperties.getDocumentDownloadType())) {
            config.append(",\n  documentDownloadType: \"").append(this.escapeJson(this.scalarProperties.getDocumentDownloadType())).append("\"");
        }
        config.append("\n}");
        return config.toString();
    }

    private String escapeJson(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private String buildSourcesJsonArray(List<ScalarProperties.ScalarSource> sources) {
        StringBuilder builder = new StringBuilder("[");
        List filteredSources = sources.stream().filter(source -> this.isNotNullOrBlank(source.getUrl())).collect(Collectors.toList());
        for (int i = 0; i < filteredSources.size(); ++i) {
            ScalarProperties.ScalarSource source2 = (ScalarProperties.ScalarSource)filteredSources.get(i);
            String sourceJson = this.buildSourceJson(source2);
            builder.append("\n").append(sourceJson);
            if (i == filteredSources.size() - 1) continue;
            builder.append(",");
        }
        builder.append("\n]");
        return builder.toString();
    }

    private String buildSourceJson(ScalarProperties.ScalarSource source) {
        StringBuilder builder = new StringBuilder("{");
        builder.append("\n  url: \"").append(this.escapeJson(source.getUrl())).append("\"");
        if (this.isNotNullOrBlank(source.getTitle())) {
            builder.append(",\n  title: \"").append(this.escapeJson(source.getTitle())).append("\"");
        }
        if (this.isNotNullOrBlank(source.getSlug())) {
            builder.append(",\n  slug: \"").append(this.escapeJson(source.getSlug())).append("\"");
        }
        if (source.isDefault() != null) {
            builder.append(",\n  default: ").append(source.isDefault());
        }
        builder.append("\n}");
        return builder.toString();
    }

    private boolean isNotNullOrBlank(String input) {
        return input != null && !input.isBlank();
    }
}

