/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.converters.models.Pageable;
import org.springdoc.core.providers.ObjectMapperProvider;

public class PageableOpenAPIConverter
implements ModelConverter {
    private static final String PAGEABLE_TO_REPLACE = "org.springframework.data.domain.Pageable";
    private static final String PAGE_REQUEST_TO_REPLACE = "org.springframework.data.domain.PageRequest";
    private static final AnnotatedType PAGEABLE = new AnnotatedType(Pageable.class).resolveAsRef(true);
    private final ObjectMapperProvider springDocObjectMapper;

    public PageableOpenAPIConverter(ObjectMapperProvider springDocObjectMapper) {
        this.springDocObjectMapper = springDocObjectMapper;
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Class cls;
        JavaType javaType = this.springDocObjectMapper.jsonMapper().constructType(type.getType());
        if (javaType != null && (PAGEABLE_TO_REPLACE.equals((cls = javaType.getRawClass()).getCanonicalName()) || PAGE_REQUEST_TO_REPLACE.equals(cls.getCanonicalName()))) {
            if (!type.isSchemaProperty()) {
                type = PAGEABLE;
            } else {
                type.name(cls.getSimpleName() + StringUtils.capitalize((String)type.getParent().getType()));
            }
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }
}

