/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.util.ArrayList;
import java.util.List;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.SpringdocBeanFactoryConfigurer;
import org.springdoc.core.customizers.ActuatorOpenApiCustomizer;
import org.springdoc.core.customizers.ActuatorOperationCustomizer;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class SpringdocActuatorBeanFactoryConfigurer
extends SpringdocBeanFactoryConfigurer {
    private List<GroupedOpenApi> groupedOpenApis;

    public SpringdocActuatorBeanFactoryConfigurer(List<GroupedOpenApi> groupedOpenApis) {
        this.groupedOpenApis = groupedOpenApis;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        BindResult result = Binder.get((Environment)this.environment).bind("management.endpoints.web", WebEndpointProperties.class);
        if (result.isBound()) {
            WebEndpointProperties webEndpointProperties = (WebEndpointProperties)result.get();
            ArrayList<GroupedOpenApi> newGroups = new ArrayList<GroupedOpenApi>();
            ActuatorOpenApiCustomizer actuatorOpenApiCustomiser = new ActuatorOpenApiCustomizer(webEndpointProperties);
            beanFactory.registerSingleton("actuatorOpenApiCustomiser", (Object)actuatorOpenApiCustomiser);
            ActuatorOperationCustomizer actuatorCustomizer = new ActuatorOperationCustomizer();
            beanFactory.registerSingleton("actuatorCustomizer", (Object)actuatorCustomizer);
            GroupedOpenApi actuatorGroup = GroupedOpenApi.builder().group("x-actuator").pathsToMatch(webEndpointProperties.getBasePath() + "/**").pathsToExclude(webEndpointProperties.getBasePath() + "/health/*").addOperationCustomizer(actuatorCustomizer).addOpenApiCustomiser(actuatorOpenApiCustomiser).build();
            newGroups.add(actuatorGroup);
            if (CollectionUtils.isEmpty(this.groupedOpenApis)) {
                GroupedOpenApi defaultGroup = GroupedOpenApi.builder().group("springdocDefault").pathsToMatch("/**").pathsToExclude(webEndpointProperties.getBasePath() + "/**").build();
                newGroups.add(defaultGroup);
            }
            newGroups.forEach(elt -> beanFactory.registerSingleton(elt.getGroup(), elt));
        }
        SpringdocActuatorBeanFactoryConfigurer.initBeanFactoryPostProcessor(beanFactory);
    }
}

