/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.util;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class Either<L, R> {
    private final L left;
    private final R right;

    public static <L, R> Either<L, R> forLeft(L left) {
        return new Either<L, Object>(Objects.requireNonNull(left), null);
    }

    public static <L, R> Either<L, R> forRight(R right) {
        return new Either<Object, R>(null, Objects.requireNonNull(right));
    }

    protected Either(@Nullable L left, @Nullable R right) {
        this.left = left;
        this.right = right;
    }

    @CheckForNull
    public L getLeft() {
        return this.left;
    }

    @CheckForNull
    public R getRight() {
        return this.right;
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public <T> T map(Function<? super L, ? extends T> mapLeft, Function<? super R, ? extends T> mapRight) {
        if (this.isLeft()) {
            return mapLeft.apply(this.getLeft());
        }
        return mapRight.apply(this.getRight());
    }
}

