/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade.forked;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.downloadcache.CachedFile;
import org.sonarsource.scanner.lib.internal.facade.forked.JavaRunner;
import org.sonarsource.scanner.lib.internal.facade.forked.JreCacheHit;
import org.sonarsource.scanner.lib.internal.util.Either;

public class ScannerEngineLauncher {
    private static final Set<String> SENSITIVE_JVM_ARGUMENTS = Set.of("sonar.login", "password", "token");
    private static final Logger LOG = LoggerFactory.getLogger(ScannerEngineLauncher.class);
    private static final String JSON_FIELD_SCANNER_PROPERTIES = "scannerProperties";
    private final JavaRunner javaRunner;
    private final Either<CachedFile, Path> scannerEngineJar;

    public ScannerEngineLauncher(JavaRunner javaRunner, Either<CachedFile, Path> scannerEngineJar) {
        this.javaRunner = javaRunner;
        this.scannerEngineJar = scannerEngineJar;
    }

    public boolean execute(Map<String, String> properties) {
        return this.javaRunner.execute(this.buildArgs(properties), ScannerEngineLauncher.buildJsonProperties(properties), ScannerEngineLauncher::tryParse);
    }

    static void tryParse(String stdout) {
        try {
            Log log = (Log)new Gson().fromJson(stdout, Log.class);
            StringBuilder sb = new StringBuilder();
            if (log.message != null) {
                sb.append(log.message);
            }
            if (log.message != null && log.stacktrace != null) {
                sb.append("\n");
            }
            if (log.stacktrace != null) {
                sb.append(log.stacktrace);
            }
            ScannerEngineLauncher.log(log.level, sb.toString());
        }
        catch (Exception e) {
            LOG.info("[stdout] {}", (Object)stdout);
        }
    }

    private static void log(String level, String msg) {
        switch (level) {
            case "ERROR": {
                LOG.error(msg);
                break;
            }
            case "WARN": {
                LOG.warn(msg);
                break;
            }
            case "DEBUG": {
                LOG.debug(msg);
                break;
            }
            case "TRACE": {
                LOG.trace(msg);
                break;
            }
            default: {
                LOG.info(msg);
            }
        }
    }

    private List<String> buildArgs(Map<String, String> properties) {
        ArrayList<String> args = new ArrayList<String>();
        String javaOpts = properties.get("sonar.scanner.javaOpts");
        if (javaOpts != null) {
            List<String> split = ScannerEngineLauncher.split(javaOpts);
            LOG.info("SONAR_SCANNER_JAVA_OPTS={}", (Object)ScannerEngineLauncher.redactSensitiveArguments(split));
            args.addAll(split);
        }
        args.add("-Dorg.bouncycastle.pkcs12.ignore_useless_passwd=true");
        args.add("-jar");
        args.add(this.scannerEngineJar.map(CachedFile::getPath, Function.identity()).toAbsolutePath().toString());
        return args;
    }

    private static String redactSensitiveArguments(List<String> scannerOpts) {
        return scannerOpts.stream().map(ScannerEngineLauncher::redactArgumentIfSensistive).collect(Collectors.joining(" "));
    }

    private static String redactArgumentIfSensistive(String argument) {
        String[] elems = argument.split("=");
        if (elems.length > 0 && SENSITIVE_JVM_ARGUMENTS.stream().anyMatch(p -> elems[0].toLowerCase(Locale.ENGLISH).contains((CharSequence)p))) {
            return elems[0] + "=*";
        }
        return argument;
    }

    private static List<String> split(String value) {
        return Arrays.stream(value.split("\\s+")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static String buildJsonProperties(Map<String, String> properties) {
        JsonArray propertiesArray = new JsonArray();
        properties.entrySet().stream().filter(prop -> prop.getKey() != null).sorted(Map.Entry.comparingByKey()).forEach(prop -> {
            JsonObject property = new JsonObject();
            property.addProperty("key", (String)prop.getKey());
            property.addProperty("value", Optional.ofNullable((String)prop.getValue()).orElse(""));
            propertiesArray.add((JsonElement)property);
        });
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(JSON_FIELD_SCANNER_PROPERTIES, (JsonElement)propertiesArray);
        return new Gson().toJson((JsonElement)jsonObject);
    }

    public Optional<Boolean> didEngineCacheHit() {
        return this.scannerEngineJar.map(c -> Optional.of(c.didCacheHit()), p -> Optional.empty());
    }

    public JreCacheHit getJreCacheHit() {
        return this.javaRunner.getJreCacheHit();
    }

    private static class Log {
        @SerializedName(value="level")
        private String level;
        @SerializedName(value="message")
        private String message;
        @SerializedName(value="stacktrace")
        private String stacktrace;

        private Log() {
        }
    }
}

