/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade.forked;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.scanner.lib.internal.cache.CachedFile;
import org.sonarsource.scanner.lib.internal.cache.FileCache;
import org.sonarsource.scanner.lib.internal.cache.HashMismatchException;
import org.sonarsource.scanner.lib.internal.facade.forked.JavaRunner;
import org.sonarsource.scanner.lib.internal.facade.forked.JavaRunnerFactory;
import org.sonarsource.scanner.lib.internal.facade.forked.ResourceMetadata;
import org.sonarsource.scanner.lib.internal.facade.forked.ScannerEngineLauncher;
import org.sonarsource.scanner.lib.internal.http.ScannerHttpClient;
import org.sonarsource.scanner.lib.internal.util.ProcessWrapperFactory;
import org.sonarsource.scanner.lib.internal.util.System2;

public class ScannerEngineLauncherFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ScannerEngineLauncherFactory.class);
    static final String API_PATH_ENGINE = "/analysis/engine";
    private final JavaRunnerFactory javaRunnerFactory;

    public ScannerEngineLauncherFactory(System2 system) {
        this.javaRunnerFactory = new JavaRunnerFactory(system, new ProcessWrapperFactory());
    }

    ScannerEngineLauncherFactory(JavaRunnerFactory javaRunnerFactory) {
        this.javaRunnerFactory = javaRunnerFactory;
    }

    public ScannerEngineLauncher createLauncher(ScannerHttpClient scannerHttpClient, FileCache fileCache, Map<String, String> properties) {
        JavaRunner javaRunner = this.javaRunnerFactory.createRunner(scannerHttpClient, fileCache, properties);
        ScannerEngineLauncherFactory.jreSanityCheck(javaRunner);
        CachedFile scannerEngine = ScannerEngineLauncherFactory.getScannerEngine(scannerHttpClient, fileCache, true);
        return new ScannerEngineLauncher(javaRunner, scannerEngine);
    }

    private static void jreSanityCheck(JavaRunner javaRunner) {
        javaRunner.execute(Collections.singletonList("--version"), null, arg_0 -> ((Logger)LOG).debug(arg_0));
    }

    private static CachedFile getScannerEngine(ScannerHttpClient scannerHttpClient, FileCache fileCache, boolean retry) {
        try {
            ScannerEngineMetadata scannerEngineMetadata = ScannerEngineLauncherFactory.getScannerEngineMetadata(scannerHttpClient);
            return fileCache.getOrDownload(scannerEngineMetadata.getFilename(), scannerEngineMetadata.getSha256(), "SHA-256", new ScannerEngineDownloader(scannerHttpClient, scannerEngineMetadata));
        }
        catch (HashMismatchException e) {
            if (retry) {
                LOG.warn("Failed to get the scanner-engine, retrying...");
                return ScannerEngineLauncherFactory.getScannerEngine(scannerHttpClient, fileCache, false);
            }
            throw e;
        }
    }

    private static ScannerEngineMetadata getScannerEngineMetadata(ScannerHttpClient scannerHttpClient) {
        try {
            String response = scannerHttpClient.callRestApi(API_PATH_ENGINE);
            return (ScannerEngineMetadata)new Gson().fromJson(response, ScannerEngineMetadata.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get the scanner-engine metadata", e);
        }
    }

    static class ScannerEngineMetadata
    extends ResourceMetadata {
        public ScannerEngineMetadata(String filename, String sha256, @Nullable String downloadUrl) {
            super(filename, sha256, downloadUrl);
        }
    }

    static class ScannerEngineDownloader
    implements FileCache.Downloader {
        private final ScannerHttpClient connection;
        private final ScannerEngineMetadata scannerEngineMetadata;

        ScannerEngineDownloader(ScannerHttpClient connection, ScannerEngineMetadata scannerEngineMetadata) {
            this.connection = connection;
            this.scannerEngineMetadata = scannerEngineMetadata;
        }

        @Override
        public void download(String filename, Path toFile) throws IOException {
            if (StringUtils.isNotBlank((CharSequence)this.scannerEngineMetadata.getDownloadUrl())) {
                this.connection.downloadFromExternalUrl(this.scannerEngineMetadata.getDownloadUrl(), toFile);
            } else {
                this.connection.downloadFromRestApi(ScannerEngineLauncherFactory.API_PATH_ENGINE, toFile);
            }
        }
    }
}

