/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.log;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.bidi.log.GenericLogEntry;
import org.openqa.selenium.bidi.log.LogLevel;
import org.openqa.selenium.bidi.log.StackTrace;
import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.bidi.script.Source;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class ConsoleLogEntry
extends GenericLogEntry {
    private final String method;
    private final List<RemoteValue> args;

    public ConsoleLogEntry(LogLevel level, Source source, String text, long timestamp, String type, String method, List<RemoteValue> args, StackTrace stackTrace) {
        super(level, source, text, timestamp, type, stackTrace);
        this.method = method;
        this.args = args;
    }

    public String getMethod() {
        return this.method;
    }

    public List<RemoteValue> getArgs() {
        return this.args;
    }

    public static ConsoleLogEntry fromJson(JsonInput input) {
        LogLevel level = null;
        Source source = null;
        String text = null;
        long timestamp = 0L;
        String type = null;
        String method = null;
        List args = null;
        StackTrace stackTrace = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "level": {
                    level = (LogLevel)((Object)input.read(LogLevel.class));
                    continue block20;
                }
                case "source": {
                    source = (Source)input.read(Source.class);
                    continue block20;
                }
                case "text": {
                    text = (String)input.read(String.class);
                    continue block20;
                }
                case "timestamp": {
                    timestamp = (Long)input.read(Long.class);
                    continue block20;
                }
                case "type": {
                    type = (String)input.read(String.class);
                    continue block20;
                }
                case "method": {
                    method = (String)input.read(String.class);
                    continue block20;
                }
                case "args": {
                    args = (List)input.read(new TypeToken<List<RemoteValue>>(){}.getType());
                    continue block20;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read(StackTrace.class);
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ConsoleLogEntry(level, source, text, timestamp, type, method, args, stackTrace);
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("type", super.getType());
        toReturn.put("source", super.getSource());
        toReturn.put("level", (Object)super.getLevel());
        toReturn.put("text", super.getText());
        toReturn.put("timestamp", super.getTimestamp());
        toReturn.put("method", this.method);
        toReturn.put("args", this.args);
        toReturn.put("stackTrace", super.getStackTrace());
        return Collections.unmodifiableMap(toReturn);
    }
}

