/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.network.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v137.network.model.BlockedSetCookieWithReason;
import org.openqa.selenium.devtools.v137.network.model.CookiePartitionKey;
import org.openqa.selenium.devtools.v137.network.model.ExemptedSetCookieWithReason;
import org.openqa.selenium.devtools.v137.network.model.Headers;
import org.openqa.selenium.devtools.v137.network.model.IPAddressSpace;
import org.openqa.selenium.devtools.v137.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ResponseReceivedExtraInfo {
    private final RequestId requestId;
    private final List<BlockedSetCookieWithReason> blockedCookies;
    private final Headers headers;
    private final IPAddressSpace resourceIPAddressSpace;
    private final Integer statusCode;
    private final Optional<String> headersText;
    private final Optional<CookiePartitionKey> cookiePartitionKey;
    private final Optional<Boolean> cookiePartitionKeyOpaque;
    private final Optional<List<ExemptedSetCookieWithReason>> exemptedCookies;

    public ResponseReceivedExtraInfo(RequestId requestId, List<BlockedSetCookieWithReason> blockedCookies, Headers headers, IPAddressSpace resourceIPAddressSpace, Integer statusCode, Optional<String> headersText, Optional<CookiePartitionKey> cookiePartitionKey, Optional<Boolean> cookiePartitionKeyOpaque, Optional<List<ExemptedSetCookieWithReason>> exemptedCookies) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.blockedCookies = Objects.requireNonNull(blockedCookies, "blockedCookies is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.resourceIPAddressSpace = Objects.requireNonNull(resourceIPAddressSpace, "resourceIPAddressSpace is required");
        this.statusCode = Objects.requireNonNull(statusCode, "statusCode is required");
        this.headersText = headersText;
        this.cookiePartitionKey = cookiePartitionKey;
        this.cookiePartitionKeyOpaque = cookiePartitionKeyOpaque;
        this.exemptedCookies = exemptedCookies;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public List<BlockedSetCookieWithReason> getBlockedCookies() {
        return this.blockedCookies;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public IPAddressSpace getResourceIPAddressSpace() {
        return this.resourceIPAddressSpace;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public Optional<String> getHeadersText() {
        return this.headersText;
    }

    @Beta
    public Optional<CookiePartitionKey> getCookiePartitionKey() {
        return this.cookiePartitionKey;
    }

    public Optional<Boolean> getCookiePartitionKeyOpaque() {
        return this.cookiePartitionKeyOpaque;
    }

    public Optional<List<ExemptedSetCookieWithReason>> getExemptedCookies() {
        return this.exemptedCookies;
    }

    private static ResponseReceivedExtraInfo fromJson(JsonInput input) {
        RequestId requestId = null;
        List blockedCookies = null;
        Headers headers = null;
        IPAddressSpace resourceIPAddressSpace = null;
        Integer statusCode = 0;
        Optional<String> headersText = Optional.empty();
        Optional<CookiePartitionKey> cookiePartitionKey = Optional.empty();
        Optional<Boolean> cookiePartitionKeyOpaque = Optional.empty();
        Optional<List<ExemptedSetCookieWithReason>> exemptedCookies = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block22;
                }
                case "blockedCookies": {
                    blockedCookies = input.readArray(BlockedSetCookieWithReason.class);
                    continue block22;
                }
                case "headers": {
                    headers = (Headers)input.read(Headers.class);
                    continue block22;
                }
                case "resourceIPAddressSpace": {
                    resourceIPAddressSpace = (IPAddressSpace)((Object)input.read(IPAddressSpace.class));
                    continue block22;
                }
                case "statusCode": {
                    statusCode = input.nextNumber().intValue();
                    continue block22;
                }
                case "headersText": {
                    headersText = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "cookiePartitionKey": {
                    cookiePartitionKey = Optional.ofNullable((CookiePartitionKey)input.read(CookiePartitionKey.class));
                    continue block22;
                }
                case "cookiePartitionKeyOpaque": {
                    cookiePartitionKeyOpaque = Optional.ofNullable(input.nextBoolean());
                    continue block22;
                }
                case "exemptedCookies": {
                    exemptedCookies = Optional.ofNullable(input.readArray(ExemptedSetCookieWithReason.class));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ResponseReceivedExtraInfo(requestId, blockedCookies, headers, resourceIPAddressSpace, statusCode, headersText, cookiePartitionKey, cookiePartitionKeyOpaque, exemptedCookies);
    }
}

