/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.page.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class AppManifestError {
    private final String message;
    private final Integer critical;
    private final Integer line;
    private final Integer column;

    public AppManifestError(String message, Integer critical, Integer line, Integer column) {
        this.message = Objects.requireNonNull(message, "message is required");
        this.critical = Objects.requireNonNull(critical, "critical is required");
        this.line = Objects.requireNonNull(line, "line is required");
        this.column = Objects.requireNonNull(column, "column is required");
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getCritical() {
        return this.critical;
    }

    public Integer getLine() {
        return this.line;
    }

    public Integer getColumn() {
        return this.column;
    }

    private static AppManifestError fromJson(JsonInput input) {
        String message = null;
        Integer critical = 0;
        Integer line = 0;
        Integer column = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "message": {
                    message = input.nextString();
                    continue block12;
                }
                case "critical": {
                    critical = input.nextNumber().intValue();
                    continue block12;
                }
                case "line": {
                    line = input.nextNumber().intValue();
                    continue block12;
                }
                case "column": {
                    column = input.nextNumber().intValue();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AppManifestError(message, critical, line, column);
    }
}

