/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v131.target.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v131.target.model.SessionID;
import org.openqa.selenium.devtools.v131.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DetachedFromTarget {
    private final SessionID sessionId;
    private final Optional<TargetID> targetId;

    public DetachedFromTarget(SessionID sessionId, Optional<TargetID> targetId) {
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId is required");
        this.targetId = targetId;
    }

    public SessionID getSessionId() {
        return this.sessionId;
    }

    @Deprecated
    public Optional<TargetID> getTargetId() {
        return this.targetId;
    }

    private static DetachedFromTarget fromJson(JsonInput input) {
        SessionID sessionId = null;
        Optional<TargetID> targetId = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "sessionId": {
                    sessionId = (SessionID)input.read(SessionID.class);
                    continue block8;
                }
                case "targetId": {
                    targetId = Optional.ofNullable((TargetID)input.read(TargetID.class));
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DetachedFromTarget(sessionId, targetId);
    }
}

