/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v130.storage.model;

import java.util.List;
import java.util.Optional;
import org.openqa.selenium.devtools.v130.storage.model.SharedStorageUrlWithMetadata;
import org.openqa.selenium.json.JsonInput;

public class SharedStorageAccessParams {
    private final Optional<String> scriptSourceUrl;
    private final Optional<String> operationName;
    private final Optional<String> serializedData;
    private final Optional<List<SharedStorageUrlWithMetadata>> urlsWithMetadata;
    private final Optional<String> key;
    private final Optional<String> value;
    private final Optional<Boolean> ignoreIfPresent;

    public SharedStorageAccessParams(Optional<String> scriptSourceUrl, Optional<String> operationName, Optional<String> serializedData, Optional<List<SharedStorageUrlWithMetadata>> urlsWithMetadata, Optional<String> key, Optional<String> value, Optional<Boolean> ignoreIfPresent) {
        this.scriptSourceUrl = scriptSourceUrl;
        this.operationName = operationName;
        this.serializedData = serializedData;
        this.urlsWithMetadata = urlsWithMetadata;
        this.key = key;
        this.value = value;
        this.ignoreIfPresent = ignoreIfPresent;
    }

    public Optional<String> getScriptSourceUrl() {
        return this.scriptSourceUrl;
    }

    public Optional<String> getOperationName() {
        return this.operationName;
    }

    public Optional<String> getSerializedData() {
        return this.serializedData;
    }

    public Optional<List<SharedStorageUrlWithMetadata>> getUrlsWithMetadata() {
        return this.urlsWithMetadata;
    }

    public Optional<String> getKey() {
        return this.key;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public Optional<Boolean> getIgnoreIfPresent() {
        return this.ignoreIfPresent;
    }

    private static SharedStorageAccessParams fromJson(JsonInput input) {
        Optional<String> scriptSourceUrl = Optional.empty();
        Optional<String> operationName = Optional.empty();
        Optional<String> serializedData = Optional.empty();
        Optional<List<SharedStorageUrlWithMetadata>> urlsWithMetadata = Optional.empty();
        Optional<String> key = Optional.empty();
        Optional<String> value = Optional.empty();
        Optional<Boolean> ignoreIfPresent = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptSourceUrl": {
                    scriptSourceUrl = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "operationName": {
                    operationName = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "serializedData": {
                    serializedData = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "urlsWithMetadata": {
                    urlsWithMetadata = Optional.ofNullable(input.readArray(SharedStorageUrlWithMetadata.class));
                    continue block18;
                }
                case "key": {
                    key = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "value": {
                    value = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "ignoreIfPresent": {
                    ignoreIfPresent = Optional.ofNullable(input.nextBoolean());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SharedStorageAccessParams(scriptSourceUrl, operationName, serializedData, urlsWithMetadata, key, value, ignoreIfPresent);
    }
}

