/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.httpclient;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.RedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.BasicManagedEntity;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.routing.BasicRouteDirector;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.EntityEnclosingRequestWrapper;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.impl.client.RoutedRequest;
import org.apache.http.impl.client.TunnelRefusedException;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.robolectric.shadows.httpclient.HttpRedirect;

public class DefaultRequestDirector
implements RequestDirector {
    private final Log log;
    protected final ClientConnectionManager connManager;
    protected final HttpRoutePlanner routePlanner;
    protected final ConnectionReuseStrategy reuseStrategy;
    protected final ConnectionKeepAliveStrategy keepAliveStrategy;
    protected final HttpRequestExecutor requestExec;
    protected final HttpProcessor httpProcessor;
    protected final HttpRequestRetryHandler retryHandler;
    protected final RedirectHandler redirectHandler;
    protected final AuthenticationHandler targetAuthHandler;
    protected final AuthenticationHandler proxyAuthHandler;
    protected final UserTokenHandler userTokenHandler;
    protected final HttpParams params;
    protected ManagedClientConnection managedConn;
    protected final AuthState targetAuthState;
    protected final AuthState proxyAuthState;
    private int redirectCount;
    private int maxRedirects;
    private HttpHost virtualHost;

    public DefaultRequestDirector(Log log, HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        if (log == null) {
            throw new IllegalArgumentException("Log may not be null.");
        }
        if (requestExec == null) {
            throw new IllegalArgumentException("Request executor may not be null.");
        }
        if (conman == null) {
            throw new IllegalArgumentException("Client connection manager may not be null.");
        }
        if (reustrat == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null.");
        }
        if (kastrat == null) {
            throw new IllegalArgumentException("Connection keep alive strategy may not be null.");
        }
        if (rouplan == null) {
            throw new IllegalArgumentException("Route planner may not be null.");
        }
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP protocol processor may not be null.");
        }
        if (retryHandler == null) {
            throw new IllegalArgumentException("HTTP request retry handler may not be null.");
        }
        if (redirectHandler == null) {
            throw new IllegalArgumentException("Redirect handler may not be null.");
        }
        if (targetAuthHandler == null) {
            throw new IllegalArgumentException("Target authentication handler may not be null.");
        }
        if (proxyAuthHandler == null) {
            throw new IllegalArgumentException("Proxy authentication handler may not be null.");
        }
        if (userTokenHandler == null) {
            throw new IllegalArgumentException("User token handler may not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.log = log;
        this.requestExec = requestExec;
        this.connManager = conman;
        this.reuseStrategy = reustrat;
        this.keepAliveStrategy = kastrat;
        this.routePlanner = rouplan;
        this.httpProcessor = httpProcessor;
        this.retryHandler = retryHandler;
        this.redirectHandler = redirectHandler;
        this.targetAuthHandler = targetAuthHandler;
        this.proxyAuthHandler = proxyAuthHandler;
        this.userTokenHandler = userTokenHandler;
        this.params = params;
        this.managedConn = null;
        this.redirectCount = 0;
        this.maxRedirects = this.params.getIntParameter("http.protocol.max-redirects", 100);
        this.targetAuthState = new AuthState();
        this.proxyAuthState = new AuthState();
    }

    public DefaultRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        this(LogFactory.getLog(DefaultRequestDirector.class), requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectHandler, targetAuthHandler, proxyAuthHandler, userTokenHandler, params);
    }

    private RequestWrapper wrapRequest(HttpRequest request) throws ProtocolException {
        if (request instanceof HttpEntityEnclosingRequest) {
            return new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request);
        }
        return new RequestWrapper(request);
    }

    protected void rewriteRequestURI(RequestWrapper request, HttpRoute route) throws ProtocolException {
        try {
            URI uri = request.getURI();
            if (route.getProxyHost() != null && !route.isTunnelled()) {
                if (!uri.isAbsolute()) {
                    HttpHost target = route.getTargetHost();
                    uri = URIUtils.rewriteURI((URI)uri, (HttpHost)target);
                    request.setURI(uri);
                }
            } else if (uri.isAbsolute()) {
                uri = URIUtils.rewriteURI((URI)uri, null);
                request.setURI(uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid URI: " + request.getRequestLine().getUri(), (Throwable)ex);
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpRequest orig = request;
        RequestWrapper origWrapper = this.wrapRequest(orig);
        origWrapper.setParams(this.params);
        HttpRoute origRoute = this.determineRoute(target, (HttpRequest)origWrapper, context);
        this.virtualHost = (HttpHost)orig.getParams().getParameter("http.virtual-host");
        RoutedRequest roureq = new RoutedRequest(origWrapper, origRoute);
        long timeout = ConnManagerParams.getTimeout((HttpParams)this.params);
        int execCount = 0;
        boolean reuse = false;
        boolean done = false;
        try {
            HttpResponse response = null;
            while (!done) {
                RoutedRequest followup;
                RequestWrapper wrapper = roureq.getRequest();
                HttpRoute route = roureq.getRoute();
                response = null;
                Object userToken = context.getAttribute("http.user-token");
                if (this.managedConn == null) {
                    ClientConnectionRequest connRequest = this.connManager.requestConnection(route, userToken);
                    if (orig instanceof AbortableHttpRequest) {
                        ((AbortableHttpRequest)orig).setConnectionRequest(connRequest);
                    }
                    try {
                        this.managedConn = connRequest.getConnection(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interrupted) {
                        InterruptedIOException iox = new InterruptedIOException();
                        iox.initCause(interrupted);
                        throw iox;
                    }
                    if (HttpConnectionParams.isStaleCheckingEnabled((HttpParams)this.params) && this.managedConn.isOpen()) {
                        this.log.debug((Object)"Stale connection check");
                        if (this.managedConn.isStale()) {
                            this.log.debug((Object)"Stale connection detected");
                            this.managedConn.close();
                        }
                    }
                }
                if (orig instanceof AbortableHttpRequest) {
                    ((AbortableHttpRequest)orig).setReleaseTrigger((ConnectionReleaseTrigger)this.managedConn);
                }
                if (!this.managedConn.isOpen()) {
                    this.managedConn.open(route, context, this.params);
                } else {
                    this.managedConn.setSocketTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
                }
                try {
                    this.establishRoute(route, context);
                }
                catch (TunnelRefusedException ex) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)ex.getMessage());
                    }
                    response = ex.getResponse();
                    break;
                }
                wrapper.resetHeaders();
                this.rewriteRequestURI(wrapper, route);
                target = this.virtualHost;
                if (target == null) {
                    target = route.getTargetHost();
                }
                HttpHost proxy = route.getProxyHost();
                context.setAttribute("http.target_host", (Object)target);
                context.setAttribute("http.proxy_host", (Object)proxy);
                context.setAttribute("http.connection", (Object)this.managedConn);
                context.setAttribute("http.auth.target-scope", (Object)this.targetAuthState);
                context.setAttribute("http.auth.proxy-scope", (Object)this.proxyAuthState);
                this.requestExec.preProcess((HttpRequest)wrapper, this.httpProcessor, context);
                boolean retrying = true;
                IOException retryReason = null;
                while (retrying) {
                    ++execCount;
                    wrapper.incrementExecCount();
                    if (!wrapper.isRepeatable()) {
                        this.log.debug((Object)"Cannot retry non-repeatable request");
                        if (retryReason != null) {
                            throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.  The cause lists the reason the original request failed: " + retryReason);
                        }
                        throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
                    }
                    try {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Attempt " + execCount + " to execute request"));
                        }
                        response = this.requestExec.execute((HttpRequest)wrapper, (HttpClientConnection)this.managedConn, context);
                        retrying = false;
                    }
                    catch (IOException ex) {
                        this.log.debug((Object)"Closing the connection.");
                        this.managedConn.close();
                        if (this.retryHandler.retryRequest(ex, wrapper.getExecCount(), context)) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info((Object)("I/O exception (" + ex.getClass().getName() + ") caught when processing request: " + ex.getMessage()));
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)ex.getMessage(), (Throwable)ex);
                            }
                        } else {
                            throw ex;
                        }
                        this.log.info((Object)"Retrying request");
                        retryReason = ex;
                        if (!route.isTunnelled()) {
                            this.log.debug((Object)"Reopening the direct connection.");
                            this.managedConn.open(route, context, this.params);
                            continue;
                        }
                        this.log.debug((Object)"Proxied connection. Need to start over.");
                        retrying = false;
                    }
                }
                if (response == null) continue;
                response.setParams(this.params);
                this.requestExec.postProcess(response, this.httpProcessor, context);
                reuse = this.reuseStrategy.keepAlive(response, context);
                if (reuse) {
                    long duration = this.keepAliveStrategy.getKeepAliveDuration(response, context);
                    this.managedConn.setIdleDuration(duration, TimeUnit.MILLISECONDS);
                    if (this.log.isDebugEnabled()) {
                        if (duration >= 0L) {
                            this.log.debug((Object)("Connection can be kept alive for " + duration + " ms"));
                        } else {
                            this.log.debug((Object)"Connection can be kept alive indefinitely");
                        }
                    }
                }
                if ((followup = this.handleResponse(roureq, response, context)) == null) {
                    done = true;
                } else {
                    if (reuse) {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            entity.consumeContent();
                        }
                        this.managedConn.markReusable();
                    } else {
                        this.managedConn.close();
                    }
                    if (!followup.getRoute().equals((Object)roureq.getRoute())) {
                        this.releaseConnection();
                    }
                    roureq = followup;
                }
                if (this.managedConn == null || userToken != null) continue;
                userToken = this.userTokenHandler.getUserToken(context);
                context.setAttribute("http.user-token", userToken);
                if (userToken == null) continue;
                this.managedConn.setState(userToken);
            }
            if (response == null || response.getEntity() == null || !response.getEntity().isStreaming()) {
                if (reuse) {
                    this.managedConn.markReusable();
                }
                this.releaseConnection();
            } else {
                HttpEntity entity = response.getEntity();
                entity = new BasicManagedEntity(entity, this.managedConn, reuse);
                response.setEntity(entity);
            }
            return response;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            this.abortConnection();
            throw ex;
        }
    }

    protected void releaseConnection() {
        try {
            this.managedConn.releaseConnection();
        }
        catch (IOException ignored) {
            this.log.debug((Object)"IOException releasing connection", (Throwable)ignored);
        }
        this.managedConn = null;
    }

    protected HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        if (target == null) {
            target = (HttpHost)request.getParams().getParameter("http.default-host");
        }
        if (target == null) {
            throw new IllegalStateException("Target host must not be null, or set in parameters.");
        }
        return this.routePlanner.determineRoute(target, request, context);
    }

    protected void establishRoute(HttpRoute route, HttpContext context) throws HttpException, IOException {
        int step;
        BasicRouteDirector rowdy = new BasicRouteDirector();
        do {
            HttpRoute fact = this.managedConn.getRoute();
            step = rowdy.nextStep((RouteInfo)route, (RouteInfo)fact);
            switch (step) {
                case 1: 
                case 2: {
                    this.managedConn.open(route, context, this.params);
                    break;
                }
                case 3: {
                    boolean secure = this.createTunnelToTarget(route, context);
                    this.log.debug((Object)"Tunnel to target created.");
                    this.managedConn.tunnelTarget(secure, this.params);
                    break;
                }
                case 4: {
                    int hop = fact.getHopCount() - 1;
                    boolean secure = this.createTunnelToProxy(route, hop, context);
                    this.log.debug((Object)"Tunnel to proxy created.");
                    this.managedConn.tunnelProxy(route.getHopTarget(hop), secure, this.params);
                    break;
                }
                case 5: {
                    this.managedConn.layerProtocol(context, this.params);
                    break;
                }
                case -1: {
                    throw new IllegalStateException("Unable to establish route.\nplanned = " + route + "\ncurrent = " + fact);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
                }
            }
        } while (step > 0);
    }

    protected boolean createTunnelToTarget(HttpRoute route, HttpContext context) throws HttpException, IOException {
        int status;
        HttpHost proxy = route.getProxyHost();
        HttpHost target = route.getTargetHost();
        HttpResponse response = null;
        boolean done = false;
        while (!done) {
            done = true;
            if (!this.managedConn.isOpen()) {
                this.managedConn.open(route, context, this.params);
            }
            HttpRequest connect = this.createConnectRequest(route, context);
            connect.setParams(this.params);
            context.setAttribute("http.target_host", (Object)target);
            context.setAttribute("http.proxy_host", (Object)proxy);
            context.setAttribute("http.connection", (Object)this.managedConn);
            context.setAttribute("http.auth.target-scope", (Object)this.targetAuthState);
            context.setAttribute("http.auth.proxy-scope", (Object)this.proxyAuthState);
            context.setAttribute("http.request", (Object)connect);
            this.requestExec.preProcess(connect, this.httpProcessor, context);
            response = this.requestExec.execute(connect, (HttpClientConnection)this.managedConn, context);
            response.setParams(this.params);
            this.requestExec.postProcess(response, this.httpProcessor, context);
            int status2 = response.getStatusLine().getStatusCode();
            if (status2 < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            if (credsProvider == null || !HttpClientParams.isAuthenticating((HttpParams)this.params)) continue;
            if (this.proxyAuthHandler.isAuthenticationRequested(response, context)) {
                block9: {
                    this.log.debug((Object)"Proxy requested authentication");
                    Map challenges = this.proxyAuthHandler.getChallenges(response, context);
                    try {
                        this.processChallenges(challenges, this.proxyAuthState, this.proxyAuthHandler, response, context);
                    }
                    catch (AuthenticationException ex) {
                        if (!this.log.isWarnEnabled()) break block9;
                        this.log.warn((Object)("Authentication error: " + ex.getMessage()));
                        break;
                    }
                }
                this.updateAuthState(this.proxyAuthState, proxy, credsProvider);
                if (this.proxyAuthState.getCredentials() == null) continue;
                done = false;
                if (this.reuseStrategy.keepAlive(response, context)) {
                    this.log.debug((Object)"Connection kept alive");
                    HttpEntity entity = response.getEntity();
                    if (entity == null) continue;
                    entity.consumeContent();
                    continue;
                }
                this.managedConn.close();
                continue;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        if ((status = response.getStatusLine().getStatusCode()) > 299) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                response.setEntity((HttpEntity)new BufferedHttpEntity(entity));
            }
            this.managedConn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        this.managedConn.markReusable();
        return false;
    }

    protected boolean createTunnelToProxy(HttpRoute route, int hop, HttpContext context) throws HttpException, IOException {
        throw new UnsupportedOperationException("Proxy chains are not supported.");
    }

    protected HttpRequest createConnectRequest(HttpRoute route, HttpContext context) {
        HttpHost target = route.getTargetHost();
        String host = target.getHostName();
        int port = target.getPort();
        if (port < 0) {
            Scheme scheme = this.connManager.getSchemeRegistry().getScheme(target.getSchemeName());
            port = scheme.getDefaultPort();
        }
        StringBuilder buffer = new StringBuilder(host.length() + 6);
        buffer.append(host);
        buffer.append(':');
        buffer.append(Integer.toString(port));
        String authority = buffer.toString();
        ProtocolVersion ver = HttpProtocolParams.getVersion((HttpParams)this.params);
        BasicHttpRequest req = new BasicHttpRequest("CONNECT", authority, ver);
        return req;
    }

    protected RoutedRequest handleResponse(RoutedRequest roureq, HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRoute route = roureq.getRoute();
        RequestWrapper request = roureq.getRequest();
        HttpParams params = request.getParams();
        if (HttpClientParams.isRedirecting((HttpParams)params) && this.redirectHandler.isRedirectRequested(response, context)) {
            if (this.redirectCount >= this.maxRedirects) {
                throw new RedirectException("Maximum redirects (" + this.maxRedirects + ") exceeded");
            }
            ++this.redirectCount;
            this.virtualHost = null;
            URI uri = this.redirectHandler.getLocationURI(response, context);
            HttpHost newTarget = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            this.targetAuthState.setAuthScope(null);
            this.proxyAuthState.setAuthScope(null);
            if (!route.getTargetHost().equals((Object)newTarget)) {
                this.targetAuthState.invalidate();
                AuthScheme authScheme = this.proxyAuthState.getAuthScheme();
                if (authScheme != null && authScheme.isConnectionBased()) {
                    this.proxyAuthState.invalidate();
                }
            }
            HttpRedirect redirect = new HttpRedirect(request.getMethod(), uri);
            HttpRequest orig = request.getOriginal();
            redirect.setHeaders(orig.getAllHeaders());
            RequestWrapper wrapper = new RequestWrapper((HttpRequest)redirect);
            wrapper.setParams(params);
            HttpRoute newRoute = this.determineRoute(newTarget, (HttpRequest)wrapper, context);
            RoutedRequest newRequest = new RoutedRequest(wrapper, newRoute);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Redirecting to '" + uri + "' via " + newRoute));
            }
            return newRequest;
        }
        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        if (credsProvider != null && HttpClientParams.isAuthenticating((HttpParams)params)) {
            if (this.targetAuthHandler.isAuthenticationRequested(response, context)) {
                HttpHost target;
                block15: {
                    target = (HttpHost)context.getAttribute("http.target_host");
                    if (target == null) {
                        target = route.getTargetHost();
                    }
                    this.log.debug((Object)"Target requested authentication");
                    Map challenges = this.targetAuthHandler.getChallenges(response, context);
                    try {
                        this.processChallenges(challenges, this.targetAuthState, this.targetAuthHandler, response, context);
                    }
                    catch (AuthenticationException ex) {
                        if (!this.log.isWarnEnabled()) break block15;
                        this.log.warn((Object)("Authentication error: " + ex.getMessage()));
                        return null;
                    }
                }
                this.updateAuthState(this.targetAuthState, target, credsProvider);
                if (this.targetAuthState.getCredentials() != null) {
                    return roureq;
                }
                return null;
            }
            this.targetAuthState.setAuthScope(null);
            if (this.proxyAuthHandler.isAuthenticationRequested(response, context)) {
                HttpHost proxy;
                block16: {
                    proxy = route.getProxyHost();
                    this.log.debug((Object)"Proxy requested authentication");
                    Map challenges = this.proxyAuthHandler.getChallenges(response, context);
                    try {
                        this.processChallenges(challenges, this.proxyAuthState, this.proxyAuthHandler, response, context);
                    }
                    catch (AuthenticationException ex) {
                        if (!this.log.isWarnEnabled()) break block16;
                        this.log.warn((Object)("Authentication error: " + ex.getMessage()));
                        return null;
                    }
                }
                this.updateAuthState(this.proxyAuthState, proxy, credsProvider);
                if (this.proxyAuthState.getCredentials() != null) {
                    return roureq;
                }
                return null;
            }
            this.proxyAuthState.setAuthScope(null);
        }
        return null;
    }

    private void abortConnection() {
        ManagedClientConnection mcc = this.managedConn;
        if (mcc != null) {
            block5: {
                this.managedConn = null;
                try {
                    mcc.abortConnection();
                }
                catch (IOException ex) {
                    if (!this.log.isDebugEnabled()) break block5;
                    this.log.debug((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            try {
                mcc.releaseConnection();
            }
            catch (IOException ignored) {
                this.log.debug((Object)"Error releasing connection", (Throwable)ignored);
            }
        }
    }

    private void processChallenges(Map<String, Header> challenges, AuthState authState, AuthenticationHandler authHandler, HttpResponse response, HttpContext context) throws MalformedChallengeException, AuthenticationException {
        String id;
        Header challenge;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null) {
            authScheme = authHandler.selectScheme(challenges, response, context);
            authState.setAuthScheme(authScheme);
        }
        if ((challenge = challenges.get((id = authScheme.getSchemeName()).toLowerCase(Locale.ENGLISH))) == null) {
            throw new AuthenticationException(id + " authorization challenge expected, but not found");
        }
        authScheme.processChallenge(challenge);
        this.log.debug((Object)"Authorization challenge processed");
    }

    private void updateAuthState(AuthState authState, HttpHost host, CredentialsProvider credsProvider) {
        Credentials creds;
        if (!authState.isValid()) {
            return;
        }
        String hostname = host.getHostName();
        int port = host.getPort();
        if (port < 0) {
            Scheme scheme = this.connManager.getSchemeRegistry().getScheme(host);
            port = scheme.getDefaultPort();
        }
        AuthScheme authScheme = authState.getAuthScheme();
        AuthScope authScope = new AuthScope(hostname, port, authScheme.getRealm(), authScheme.getSchemeName());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication scope: " + authScope));
        }
        if ((creds = authState.getCredentials()) == null) {
            creds = credsProvider.getCredentials(authScope);
            if (this.log.isDebugEnabled()) {
                if (creds != null) {
                    this.log.debug((Object)"Found credentials");
                } else {
                    this.log.debug((Object)"Credentials not found");
                }
            }
        } else if (authScheme.isComplete()) {
            this.log.debug((Object)"Authentication failed");
            creds = null;
        }
        authState.setAuthScope(authScope);
        authState.setCredentials(creds);
    }
}

