package org.robolectric.shadows.httpclient;
import android.net.http.AndroidHttpClient;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.http.impl.client.DefaultRequestDirector;
import org.robolectric.internal.ShadowExtractor;
import org.robolectric.internal.ShadowProvider;
import org.robolectric.shadows.ShadowAndroidHttpClient;
import org.robolectric.shadows.httpclient.ShadowDefaultRequestDirector;

/**
 * Shadow mapper. Automatically generated by the Robolectric Annotation Processor.
 */
@Generated("org.robolectric.annotation.processing.RobolectricProcessor")
@SuppressWarnings({"unchecked","deprecation"})
public class Shadows implements ShadowProvider {
  private static final Map<String, String> SHADOW_MAP = new HashMap<>(2);

  static {
    SHADOW_MAP.put("android.net.http.AndroidHttpClient", "org.robolectric.shadows.ShadowAndroidHttpClient");
    SHADOW_MAP.put("org.apache.http.impl.client.DefaultRequestDirector", "org.robolectric.shadows.httpclient.ShadowDefaultRequestDirector");
  }

  public static ShadowAndroidHttpClient shadowOf(AndroidHttpClient actual) {
    return (ShadowAndroidHttpClient) ShadowExtractor.extract(actual);
  }

  public static ShadowDefaultRequestDirector shadowOf(DefaultRequestDirector actual) {
    return (ShadowDefaultRequestDirector) ShadowExtractor.extract(actual);
  }

  public void reset() {
    ShadowDefaultRequestDirector.reset();
  }

  @Override
  public Map<String, String> getShadowMap() {
    return SHADOW_MAP;
  }

  @Override
  public String[] getProvidedPackageNames() {
    return new String[] {"android.net.http","org.apache.http.impl.client"};
  }
}
