/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import org.restlet.Request;
import org.restlet.data.Header;
import org.restlet.data.Reference;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.util.Series;

public class ReferenceUtils {
    public static Reference update(Reference resourceRef, Request request) {
        Reference result = resourceRef.isAbsolute() ? resourceRef : resourceRef.getTargetRef();
        result = AuthenticatorUtils.updateReference(result, request.getChallengeResponse(), request);
        return result;
    }

    public static String format(Reference resourceRef, boolean isProxied, Request request) {
        Object result = null;
        Reference requestRef = ReferenceUtils.update(resourceRef, request);
        if (isProxied) {
            result = requestRef.getIdentifier();
        } else {
            result = requestRef.hasQuery() ? requestRef.getPath() + "?" + requestRef.getQuery() : requestRef.getPath();
            if (result == null || ((String)result).isEmpty()) {
                result = "/";
            }
        }
        return result;
    }

    public static Reference getOriginalRef(Reference resourceRef, Series<Header> headers) {
        Reference originalRef = resourceRef.getTargetRef();
        if (headers == null) {
            return originalRef;
        }
        String value = headers.getFirstValue("X-Forwarded-Port");
        if (value != null) {
            originalRef.setHostPort(Integer.parseInt(value));
        }
        if ((value = headers.getFirstValue("X-Forwarded-Proto")) != null) {
            originalRef.setScheme(value);
        }
        return originalRef;
    }

    private ReferenceUtils() {
    }
}

