/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Callback;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Header;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.util.Series;

public class JettyServerCall
extends ServerCall {
    private final Request request;
    private final org.eclipse.jetty.server.Response response;
    private final Callback callback;
    private volatile boolean requestHeadersAdded;

    public JettyServerCall(Server server, Request request, org.eclipse.jetty.server.Response response, Callback callback) {
        super(server);
        this.request = request;
        this.response = response;
        this.callback = callback;
        this.requestHeadersAdded = false;
    }

    @Override
    public boolean abort() {
        this.getEndPoint().close();
        return true;
    }

    @Override
    public void complete() {
        this.getCallback().succeeded();
    }

    @Override
    public void flushBuffers() throws IOException {
        this.getEndPoint().flush(new ByteBuffer[0]);
    }

    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public List<Certificate> getCertificates() {
        SslConnection.SslEndPoint sslEndPoint;
        EndPoint endPoint = this.getEndPoint();
        List<X509Certificate> result = endPoint instanceof SslConnection.SslEndPoint ? ((sslEndPoint = (SslConnection.SslEndPoint)endPoint).getSslSessionData() != null && sslEndPoint.getSslSessionData().peerCertificates() != null ? Arrays.asList(sslEndPoint.getSslSessionData().peerCertificates()) : null) : null;
        return result;
    }

    public Request getRequest() {
        return this.request;
    }

    public org.eclipse.jetty.server.Response getResponse() {
        return this.response;
    }

    @Override
    public String getCipherSuite() {
        EndPoint endPoint = this.getEndPoint();
        if (endPoint instanceof SslConnection.SslEndPoint) {
            SslConnection.SslEndPoint sslEndPoint = (SslConnection.SslEndPoint)endPoint;
            return sslEndPoint.getSslSessionData().cipherSuite();
        }
        return null;
    }

    @Override
    public String getClientAddress() {
        return Request.getRemoteAddr((Request)this.getRequest());
    }

    @Override
    public int getClientPort() {
        return Request.getRemotePort((Request)this.getRequest());
    }

    protected Connection getConnection() {
        return this.getRequest().getConnectionMetaData().getConnection();
    }

    protected EndPoint getEndPoint() {
        return this.getConnection().getEndPoint();
    }

    @Override
    public String getMethod() {
        return this.getRequest().getMethod();
    }

    @Override
    public InputStream getRequestEntityStream(long size) {
        return Request.asInputStream((Request)this.getRequest());
    }

    @Override
    public String getHostDomain() {
        return this.request.getHttpURI().getHost();
    }

    @Override
    public int getHostPort() {
        return this.request.getHttpURI().getPort();
    }

    @Override
    public Series<Header> getRequestHeaders() {
        Series<Header> result = super.getRequestHeaders();
        if (!this.requestHeadersAdded) {
            for (HttpField field : this.getRequest().getHeaders()) {
                result.add(field.getName(), field.getValue());
            }
            this.requestHeadersAdded = true;
        }
        return result;
    }

    @Override
    public InputStream getRequestHeadStream() {
        return null;
    }

    @Override
    public String getRequestUri() {
        return this.getRequest().getHttpURI().asString();
    }

    @Override
    public OutputStream getResponseEntityStream() {
        return org.eclipse.jetty.server.Response.asBufferedOutputStream((Request)this.getRequest(), (org.eclipse.jetty.server.Response)this.getResponse());
    }

    @Override
    public String getServerAddress() {
        return Request.getLocalAddr((Request)this.getRequest());
    }

    @Override
    public Integer getSslKeySize() {
        EndPoint endPoint = this.getEndPoint();
        if (endPoint instanceof SslConnection.SslEndPoint) {
            SslConnection.SslEndPoint sslEndPoint = (SslConnection.SslEndPoint)endPoint;
            return sslEndPoint.getSslSessionData().keySize();
        }
        return null;
    }

    @Override
    public String getSslSessionId() {
        EndPoint endPoint = this.getEndPoint();
        if (endPoint instanceof SslConnection.SslEndPoint) {
            SslConnection.SslEndPoint sslEndPoint = (SslConnection.SslEndPoint)endPoint;
            return sslEndPoint.getSslSessionData().sslSessionId();
        }
        return null;
    }

    @Override
    public boolean isConfidential() {
        return this.getRequest().isSecure();
    }

    @Override
    public boolean isConnectionBroken(Throwable exception) {
        return exception instanceof EofException || super.isConnectionBroken(exception);
    }

    @Override
    public void sendResponse(Response response) throws IOException {
        for (Header header : this.getResponseHeaders()) {
            this.getResponse().getHeaders().add(header.getName(), header.getValue());
        }
        this.getResponse().setStatus(this.getStatusCode());
        super.sendResponse(response);
    }
}

