/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.restlet.data.CharacterSet;

public class WriterOutputStream
extends OutputStream {
    private final Charset charSet;
    private final Writer writer;

    public WriterOutputStream(Writer writer, CharacterSet characterSet) {
        this.writer = writer;
        this.charSet = characterSet == null ? Charset.forName("ISO-8859-1") : characterSet.toCharset();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.writer.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        CharBuffer charBuffer = this.charSet.decode(ByteBuffer.wrap(b, off, len));
        this.writer.write(charBuffer.toString());
    }

    @Override
    public void write(int b) throws IOException {
        this.writer.write(b);
    }
}

