/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc;

import com.typesafe.config.ConfigFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServlet;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.apache.log4j.Logger;
import org.restcomm.sbc.Bootstrapper;
import org.restcomm.sbc.ConfigurationStringLookup;
import org.restcomm.sbc.Version;
import org.restcomm.sbc.bo.shiro.ShiroResources;
import org.restcomm.sbc.configuration.RestcommConfiguration;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.identity.IdentityContext;
import org.restcomm.sbc.loader.ObjectFactory;
import org.restcomm.sbc.loader.ObjectInstantiationException;

public final class Bootstrapper
extends SipServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(Bootstrapper.class);

    public Bootstrapper() {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new MyExceptionHandler(this));
    }

    public void destroy() {
    }

    private String home(ServletConfig config) {
        ServletContext context = config.getServletContext();
        String path = context.getRealPath("/");
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public void init(ServletConfig config) throws ServletException {
        ServletContext context = config.getServletContext();
        String path = context.getRealPath("WEB-INF/conf/sbc.xml");
        ConfigurationStringLookup strings = new ConfigurationStringLookup();
        strings.addProperty("home", this.home(config));
        strings.addProperty("uri", this.uri(config));
        ConfigurationInterpolator.registerGlobalLookup((String)"sbc", (StrLookup)strings);
        XMLConfiguration xml = null;
        try {
            xml = new XMLConfiguration(path);
        }
        catch (ConfigurationException exception) {
            LOG.error((Object)exception);
        }
        xml.setProperty("runtime-settings.home-directory", (Object)this.home(config));
        xml.setProperty("runtime-settings.root-uri", (Object)this.uri(config));
        context.setAttribute(Configuration.class.getName(), (Object)xml);
        ClassLoader loader = this.getClass().getClassLoader();
        ConfigFactory.load();
        DaoManager storage = null;
        try {
            storage = this.storage((Configuration)xml, loader);
        }
        catch (ObjectInstantiationException exception) {
            throw new ServletException((Throwable)exception);
        }
        context.setAttribute(DaoManager.class.getName(), (Object)storage);
        ShiroResources.getInstance().set(DaoManager.class, (Object)storage);
        ShiroResources.getInstance().set(Configuration.class, (Object)xml.subset("runtime-settings"));
        RestcommConfiguration.createOnce((Configuration)xml);
        IdentityContext identityContext = new IdentityContext((Configuration)xml);
        context.setAttribute(IdentityContext.class.getName(), (Object)identityContext);
        Version.printVersion();
    }

    private DaoManager storage(Configuration configuration, ClassLoader loader) throws ObjectInstantiationException {
        String classpath = configuration.getString("dao-manager[@class]");
        DaoManager daoManager = (DaoManager)new ObjectFactory(loader).getObjectInstance(classpath);
        daoManager.configure(configuration.subset("dao-manager"));
        daoManager.start();
        LOG.info((Object)"DaoManager started");
        return daoManager;
    }

    private String uri(ServletConfig config) {
        return config.getServletContext().getContextPath();
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

