/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.chain.impl;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.restcomm.chain.ParallelProcessorChain;
import org.restcomm.chain.SerialProcessorChain;
import org.restcomm.chain.impl.MalformedProcessorChainException;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.Processor;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.MutableMessage;
import org.restcomm.chain.processor.impl.ProcessorParsingException;

public abstract class DefaultSerialProcessorChain
extends DefaultProcessor
implements SerialProcessorChain {
    private static transient Logger LOG = Logger.getLogger(DefaultSerialProcessorChain.class);
    private Processor startPoint;
    private HashMap<Integer, Processor> processors = new HashMap();

    public DefaultSerialProcessorChain() {
    }

    public DefaultSerialProcessorChain(String name) {
        super(name);
    }

    public void link(Processor processor, Processor nextInChain) throws MalformedProcessorChainException {
        if (processor == null || nextInChain == null) {
            throw new MalformedProcessorChainException("Processors could not be null");
        }
        if (this.processors.containsValue(nextInChain)) {
            throw new MalformedProcessorChainException("Processor " + nextInChain.getName() + " already in chain");
        }
        if (processor.getId() == nextInChain.getId()) {
            throw new MalformedProcessorChainException("Loop detected " + nextInChain.getName() + " illegal recursion");
        }
        if (this.startPoint != null && processor.getId() == this.startPoint.getId()) {
            throw new MalformedProcessorChainException("Loop detected " + nextInChain.getName() + " illegal recursion, Check double start point");
        }
        if (this.processors.isEmpty()) {
            this.startPoint = processor;
        }
        if (processor instanceof ParallelProcessorChain) {
            ParallelProcessorChain ppc = (ParallelProcessorChain)processor;
            ppc.setNextLink(nextInChain);
        }
        this.processors.put(processor.getId(), nextInChain);
    }

    public Processor getNextLink(Processor processor) {
        return (Processor)this.processors.get(processor.getId());
    }

    public int getId() {
        return this.hashCode();
    }

    public void process(MutableMessage message) throws ProcessorParsingException {
        Processor nextLink;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> DSC " + this.getType() + " input message [" + message + "]"));
        }
        this.fireProcessingEvent((Message)message, (Processor)this.getCallback());
        this.getCallback().doProcess((Message)message);
        this.startPoint.process(message);
        if (this.chain != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("DSC " + this.getType() + " from callback " + this.getCallback() + " chain " + this.chain));
        }
        if ((nextLink = this.getNextLink((Processor)((DefaultProcessor)this.getCallback()))) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DSC " + this.getType() + " from callback " + this.getCallback() + " nextlink " + nextLink));
            }
            nextLink.process(message);
        }
        this.fireEndEvent((Message)message, (Processor)this.getCallback());
    }
}

