/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Route;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class RouteConverter
extends AbstractConverter
implements JsonSerializer<Route> {
    public RouteConverter(Configuration configuration) {
        super(configuration);
    }

    public boolean canConvert(Class klass) {
        return Route.class.equals((Object)klass);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Route route = (Route)object;
        writer.startNode("Route");
        this.writeSid(route.getSid(), writer);
        this.writeSid(route.getSourceConnector(), "SourceConnectorSid", writer);
        this.writeSid(route.getTargetConnector(), "TargetConnectorSid", writer);
        this.writeAccountSid(route.getAccountSid(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Route route, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(route.getSid(), object);
        this.writeSid(route.getSourceConnector(), "source_connector_sid", object);
        this.writeSid(route.getTargetConnector(), "target_connector_sid", object);
        this.writeAccountSid(route.getAccountSid(), object);
        return object;
    }

    protected void writeSid(Sid sid, String name, HierarchicalStreamWriter writer) {
        writer.startNode(name);
        writer.setValue(sid.toString());
        writer.endNode();
    }

    protected void writeSid(Sid sid, String name, JsonObject object) {
        object.addProperty(name, sid.toString());
    }
}

