/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media.srtp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.bouncycastle.x509.X509V1CertificateGenerator;
import org.restcomm.sbc.media.srtp.PemFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class JDKKeyPairGenerator {
    protected static final Logger LOGGER = Logger.getLogger(JDKKeyPairGenerator.class);
    private ECParameterSpec ecSpec;

    public JDKKeyPairGenerator() {
        EllipticCurve curve = new EllipticCurve(new ECFieldFp(new BigInteger("883423532389192164791648750360308885314476597252960362792450860609699839")), new BigInteger("7fffffffffffffffffffffff7fffffffffff8000000000007ffffffffffc", 16), new BigInteger("6b016c3bdcf18941d0d654921475ca71a9db2fb27d1d37796185c2942c0a", 16));
        this.ecSpec = new ECParameterSpec(curve, ECPointUtil.decodePoint((EllipticCurve)curve, (byte[])Hex.decode((String)"020ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf")), new BigInteger("883423532389192164791648750360308884807550341691627752275345424702807307"), 1);
    }

    public KeyPair createKeyPair() {
        KeyPair pair = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyPairGenerator g = KeyPairGenerator.getInstance("ECDSA", "BC");
            g.initialize(this.ecSpec, new SecureRandom());
            pair = g.generateKeyPair();
            JDKKeyPairGenerator.writePemFile((Key)pair.getPrivate(), (String)"ECDSA PRIVATE KEY", (String)"x509-server-ecdsa.private.pem");
            JDKKeyPairGenerator.writePemFile((Key)pair.getPublic(), (String)"ECDSA PUBLIC KEY", (String)"x509-server-ecdsa.public.pem");
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            e.printStackTrace();
        }
        return pair;
    }

    public X509Certificate createCertificate(KeyPair keyPair) throws IOException, CertificateEncodingException {
        X509Certificate cert = null;
        Date startDate = new Date();
        Date expiryDate = new Date(startDate.getTime() + -2070773760L);
        BigInteger serialNumber = BigInteger.valueOf(1234567890L);
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        X500Principal dnName = new X500Principal("CN=Test CA Certificate");
        certGen.setSerialNumber(serialNumber);
        certGen.setIssuerDN(dnName);
        certGen.setNotBefore(startDate);
        certGen.setNotAfter(expiryDate);
        certGen.setSubjectDN(dnName);
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm("SHA1withECDSA");
        try {
            cert = certGen.generate(keyPair.getPrivate(), "BC");
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateEncodingException e) {
            e.printStackTrace();
        }
        File publicKeyFile = new File(System.getProperty("user.home") + "/certs/x509-server-ecdsa.cert.pem");
        PemWriter publicPemWriter = new PemWriter((Writer)new FileWriter(publicKeyFile));
        publicPemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", cert.getEncoded()));
        publicPemWriter.flush();
        publicPemWriter.close();
        return cert;
    }

    private static void writePemFile(Key key, String description, String filename) throws FileNotFoundException, IOException {
        PemFile pemFile = new PemFile(key, description);
        filename = System.getProperty("user.home") + "/certs/" + filename;
        pemFile.write(filename);
        LOGGER.info((Object)String.format("%s successfully writen in file %s.", description, filename));
        System.out.println(String.format("%s successfully writen in file %s.", description, filename));
    }

    public static void main(String[] argv) throws CertificateEncodingException, IOException {
        JDKKeyPairGenerator kpg = new JDKKeyPairGenerator();
        KeyPair pair = kpg.createKeyPair();
        kpg.createCertificate(pair);
    }
}

