/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.IceAuthenticator;
import org.mobicents.media.io.ice.IceHandler;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.impl.rtp.crypto.RawPacket;
import org.mobicents.media.server.impl.srtp.DtlsListener;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;
import org.mobicents.media.server.spi.ConnectionMode;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.media.AudioChannel;
import org.restcomm.sbc.media.CryptoMediaZone;
import org.restcomm.sbc.media.MediaController;
import org.restcomm.sbc.media.MediaZone;
import org.restcomm.sbc.media.RtcpChannel;
import org.restcomm.sbc.media.RtpChannel;
import org.restcomm.sbc.media.dtls.DtlsHandler;
import org.restcomm.sbc.media.srtp.RtpConnection;

public class CryptoMediaZone
extends MediaZone
implements DtlsListener,
RtpListener {
    private static transient Logger LOG = Logger.getLogger(CryptoMediaZone.class);
    private RtpConnection rtpConnection;
    private AudioChannel audioChannel;
    private IceAuthenticator iceAuthenticator;
    private RtcpChannel rtcpChannel;
    private RtpChannel rtpChannel;
    private IceHandler stunHandler;
    private DtlsHandler dtlsHandler;
    private Packet packetType;
    byte[] buffer = new byte[1500];
    DatagramPacket dgram = new DatagramPacket(this.buffer, 1500);

    public CryptoMediaZone(MediaController controller, MediaZone.Direction direction, String mediaType, String originalHost, int originalRtpPort, int originalRtcpPort, boolean canMux, int proxyPort) throws UnknownHostException {
        super(controller, direction, mediaType, originalHost, originalRtpPort, originalRtcpPort, canMux, proxyPort);
        this.rtpConnection = new RtpConnection(originalHost, originalRtpPort);
    }

    public void setLocalProxy(String proxyHost) throws UnknownHostException, SocketException {
        super.setLocalProxy(proxyHost);
    }

    private void attachChannel() {
        try {
            this.rtpConnection.setNegotiatedFormats(this.controller.getNegociatedFormats());
            this.rtpConnection.bind();
            this.rtpConnection.setOtherParty(this.mediaZonePeer.channel, this.controller.getSdp().toString().getBytes());
            this.rtpConnection.setMode(ConnectionMode.SEND_RECV);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot set OtherParty!", (Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("This  Party " + this.controller.toPrint()));
            LOG.trace((Object)("Other Party " + this.controller.getOtherParty().toPrint()));
        }
        this.controller.getOtherParty().setSecureSdp(this.rtpConnection.getLocalSdp());
        if (ConfigurationCache.isMediaDecryptionEnabled()) {
            this.mediaZonePeer.suspend();
            this.audioChannel = this.rtpConnection.getAudioChannel();
            this.iceAuthenticator = this.audioChannel.getIceAuthenticator();
            this.rtcpChannel = this.audioChannel.getRtcpChannel();
            this.rtpChannel = this.audioChannel.getRtpChannel();
            this.stunHandler = this.rtcpChannel.getStunHandler();
            this.stunHandler.setAuthenticator(this.iceAuthenticator);
            this.dtlsHandler = this.rtcpChannel.getDtlsHandler();
            this.dtlsHandler.setChannel(this.mediaZonePeer.channel);
            try {
                this.rtcpChannel.bind(this.mediaZonePeer.channel);
            }
            catch (SocketException e) {
                LOG.error((Object)"Cannot bind Channel", (Throwable)e);
            }
            this.dtlsHandler.addListener((DtlsListener)this);
        }
    }

    public void start() throws UnknownHostException {
        this.attachChannel();
        if (this.isRunning()) {
            LOG.warn((Object)"Media Proxy is just running, silently ignoring");
            return;
        }
        this.setRunning(true);
        this.executorService = Executors.newCachedThreadPool();
        if (ConfigurationCache.isMediaDecryptionEnabled()) {
            this.executorService.execute((Runnable)new HandShaker(this));
        } else {
            this.executorService.execute((Runnable)new MediaZone.Proxy((MediaZone)this));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Started " + this.isRunning() + "->" + this.toPrint()));
        }
    }

    public String toPrint() {
        String value = "(CMZ " + this.direction + ") " + this.hashCode() + " " + this.mediaType + ", Origin " + this.originalHost + ":" + this.originalRtpPort + ", LocalProxy " + this.proxyHost + ":" + this.proxyPort;
        if (this.mediaZonePeer != null) {
            value = value + "[(" + this.mediaZonePeer.direction + ") " + this.mediaZonePeer.hashCode() + " " + this.mediaZonePeer.mediaType + ", Origin " + this.mediaZonePeer.originalHost + ":" + this.mediaZonePeer.originalRtpPort + ", LocalProxy " + this.mediaZonePeer.proxyHost + ":" + this.mediaZonePeer.proxyPort + "]";
        }
        return value;
    }

    public void onDtlsHandshakeComplete() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Handshake completed");
        }
        this.controller.getMediaSession().fireMediaReadyEvent((MediaZone)this);
        this.mediaZonePeer.resume();
    }

    public String getLocalSdp() {
        return this.rtpConnection.getLocalDescriptor();
    }

    public void onDtlsHandshakeFailed(Throwable t) {
        if (LOG.isTraceEnabled()) {
            LOG.error((Object)"Handshake failed");
        }
        this.controller.getMediaSession().fireMediaFailedEvent((MediaZone)this);
        this.finalize();
    }

    public void onRtpFailure(Throwable e) {
        LOG.error((Object)"RTP Failure ", e);
    }

    public void onRtpFailure(String message) {
        LOG.error((Object)("RTP Failure " + message));
    }

    public void onRtcpFailure(Throwable e) {
        LOG.error((Object)"RTCP Failure ", e);
    }

    public void onRtcpFailure(String message) {
        LOG.error((Object)("RTCP Failure " + message));
    }

    public byte[] encodeRTP(byte[] data, int offset, int length) {
        if (ConfigurationCache.isMediaDecodingEnabled()) {
            return this.dtlsHandler.encodeRTP(data, offset, length);
        }
        return ArrayUtils.subarray((byte[])data, (int)offset, (int)length);
    }

    public byte[] decodeRTP(byte[] data, int offset, int length) {
        if (ConfigurationCache.isMediaDecodingEnabled()) {
            return this.dtlsHandler.decodeRTP(data, offset, length);
        }
        return ArrayUtils.subarray((byte[])data, (int)offset, (int)length);
    }

    public void sendData(DatagramPacket dgram) throws IOException {
        if (dgram == null) {
            return;
        }
        if (dgram.getData().length > 8) {
            RawPacket rtp = new RawPacket(dgram.getData(), 0, dgram.getLength());
            LOG.trace((Object)("-++>" + this.packetType + "[PayloadType " + rtp.getPayloadType() + "](" + this.mediaType + ", " + this.direction + ") LocalProxy " + this.mediaZonePeer.proxyHost + ":" + this.mediaZonePeer.proxyPort + "/" + dgram.getAddress() + ":" + dgram.getPort() + "[" + dgram.getLength() + "]"));
        }
        this.mediaZonePeer.socket.send(dgram);
    }

    public void send(DatagramPacket dgram) throws IOException {
        if (dgram == null) {
            return;
        }
        dgram.setAddress(this.mediaZonePeer.getOriginalAddress());
        dgram.setPort(this.mediaZonePeer.getOriginalRtpPort());
        if (dgram.getData().length > 8 && this.logCounter == this.rtpCountLog) {
            RawPacket rtp = new RawPacket(dgram.getData(), 0, dgram.getLength());
            LOG.trace((Object)("--->[PayloadType " + rtp.getPayloadType() + "](" + this.mediaType + ", " + this.direction + ") LocalProxy " + this.proxyHost + ":" + this.proxyPort + "/" + dgram.getAddress() + ":" + dgram.getPort() + "[" + dgram.getLength() + "]"));
            this.logCounter = 0;
        }
        ++this.packetsSentCounter;
        this.socket.send(dgram);
    }

    public DatagramPacket receive() throws IOException {
        byte[] buffer = new byte[1500];
        DatagramPacket dgram = new DatagramPacket(buffer, 1500);
        if (this.mediaZonePeer.socket == null) {
            throw new IOException("NULL Socket on " + this.toPrint());
        }
        this.mediaZonePeer.socket.receive(dgram);
        if (dgram == null || dgram.getLength() < 8) {
            LOG.warn((Object)("RTPPacket too short, sending anyway " + this.toPrint()));
            return dgram;
        }
        byte[] result = this.handle(dgram);
        if (result == null) {
            return null;
        }
        dgram.setData(result, 0, result.length);
        ++this.logCounter;
        if (this.logCounter == this.rtpCountLog) {
            RawPacket rtp = new RawPacket(dgram.getData(), 0, dgram.getLength());
            LOG.trace((Object)("<++-" + this.packetType + "[PayloadType " + rtp.getPayloadType() + "](" + this.mediaType + ", " + this.direction + ") LocalProxy " + this.proxyHost + ":" + this.proxyPort + "/" + dgram.getAddress() + ":" + dgram.getPort() + "[" + dgram.getLength() + "]"));
        }
        ++this.packetsRecvCounter;
        return dgram;
    }

    public byte[] handle(DatagramPacket dgram) {
        byte[] packet = dgram.getData();
        InetSocketAddress local = new InetSocketAddress(this.mediaZonePeer.proxyHost, this.proxyPort);
        InetSocketAddress remote = new InetSocketAddress(dgram.getAddress().getHostAddress(), dgram.getPort());
        if (this.rtcpChannel.canHandleRTCP(packet)) {
            this.packetType = Packet.RTCP;
            return packet;
        }
        if (this.rtcpChannel.canHandleDTLS(packet)) {
            this.packetType = Packet.DTLS;
            return null;
        }
        if (this.rtcpChannel.canHandleICE(packet)) {
            this.packetType = Packet.ICE;
            try {
                byte[] response = this.stunHandler.handle(packet, local, remote);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ufrag SecurityCheck PASSED, replying from " + local.toString() + " to " + remote.toString()));
                }
                return response;
            }
            catch (PacketHandlerException e) {
                LOG.error((Object)"Cannot handle ICE", (Throwable)e);
                return packet;
            }
        }
        this.packetType = Packet.RTP;
        return this.decodeRTP(dgram.getData(), 0, dgram.getLength());
    }

    public boolean equals(Object zone) {
        if (!(zone instanceof CryptoMediaZone)) {
            return false;
        }
        CryptoMediaZone otherZone = (CryptoMediaZone)zone;
        return otherZone.getOriginalHost().equals(this.getOriginalHost()) && otherZone.getController().equals((Object)this.getController()) && otherZone.getOriginalRtpPort() == this.getOriginalRtpPort() && otherZone.getMediaType().equals(this.getMediaType()) && otherZone.getDirection().equals((Object)this.getDirection());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.controller == null ? 0 : this.controller.hashCode());
        result = prime * result + (this.originalHost == null ? 0 : this.originalHost.hashCode());
        result = prime * result + (this.originalRtpPort == 0 ? 0 : this.originalRtpPort);
        result = prime * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = prime * result + (this.direction == null ? 0 : this.direction.hashCode());
        return result;
    }

    static /* synthetic */ Packet access$000(CryptoMediaZone x0) {
        return x0.packetType;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }
}

