/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.infinispan.Cache;
import org.restcomm.sbc.bo.Location;
import org.restcomm.sbc.bo.LocationFilter;
import org.restcomm.sbc.bo.LocationNotFoundException;
import org.restcomm.sbc.managers.CacheManager;

public class LocationManager {
    private Cache<String, Location> registers = CacheManager.getCacheManager().getCache("location");
    private static LocationManager locationManager;
    private static final Logger LOG;

    private LocationManager() {
        this.registers.start();
    }

    public static LocationManager getLocationManager() {
        if (locationManager == null) {
            locationManager = new LocationManager();
        }
        return locationManager;
    }

    public void register(Location location, String userAgent, String callID, int cSeq, int ttl) {
        location.setUserAgent(userAgent);
        location.setCallID(callID);
        location.setcSeq(cSeq);
        location.setExpirationTimeInSeconds(ttl);
        this.registers.put((Object)this.key(location.getUser(), location.getDomain()), (Object)location, (long)ttl, TimeUnit.SECONDS);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("registers.put " + this.key(location.getUser(), location.getDomain()) + ":" + ttl + " secs."));
        }
    }

    public Location unregister(String user, String domain) {
        return (Location)this.registers.remove((Object)this.key(user, domain));
    }

    public Location unregister(String aor) {
        return (Location)this.registers.remove((Object)aor);
    }

    public Location getLocation(String user, String domain) throws LocationNotFoundException {
        Location location = (Location)this.registers.get((Object)this.key(user, domain));
        if (location == null) {
            throw new LocationNotFoundException(this.key(user, domain));
        }
        return location;
    }

    public Location getLocation(String aor) throws LocationNotFoundException {
        Location location = (Location)this.registers.get((Object)aor);
        if (location == null) {
            throw new LocationNotFoundException(aor);
        }
        return location;
    }

    public Collection<Location> getLocations() {
        ArrayList<Location> al = new ArrayList<Location>((Collection<Location>)this.registers.values());
        return al;
    }

    public boolean isExpired(String user, String domain) throws LocationNotFoundException {
        boolean result;
        Location location = this.getLocation(user, domain);
        boolean bl = result = location != null && !location.isExpired();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isExpired " + result + ":" + location));
        }
        return result;
    }

    public boolean exists(String user, String domain) {
        try {
            return this.getLocation(user, domain) != null;
        }
        catch (LocationNotFoundException e) {
            return false;
        }
    }

    public boolean match(String user, String domain) throws LocationNotFoundException {
        Location location;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("match " + user));
        }
        return (location = this.getLocation(user, domain)) != null;
    }

    public int getTotalLocations(LocationFilter filterForTotal) {
        int counter = 0;
        for (Object l : this.registers.values()) {
            Location location = (Location)l;
            String fHost = filterForTotal.getHost();
            String fUser = filterForTotal.getUser();
            String fTransport = filterForTotal.getTransport();
            if (fHost != null && !location.getHost().startsWith(fHost.replace("%", "")) || fUser != null && !location.getUser().startsWith(fUser.replace("%", "")) || fTransport != null && !location.getTransport().startsWith(fTransport)) continue;
            ++counter;
        }
        return counter;
    }

    public List<Location> getLocations(LocationFilter filter) {
        int offsetCounter = 0;
        int limitCounter = 0;
        int limit = filter.getLimit();
        int offset = filter.getOffset();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (Object l : this.registers.values()) {
            Location location = (Location)l;
            String fHost = filter.getHost();
            String fUser = filter.getUser();
            String fTransport = filter.getTransport();
            if (fHost != null && !location.getHost().startsWith(fHost.replace("%", "")) || fUser != null && !location.getUser().startsWith(fUser.replace("%", "")) || fTransport != null && !location.getTransport().startsWith(fTransport) || ++offsetCounter <= offset || limitCounter >= limit) continue;
            locations.add(location);
            ++limitCounter;
        }
        return locations;
    }

    private String key(String user, String domain) {
        return user + "@" + domain;
    }

    static {
        LOG = Logger.getLogger(LocationManager.class);
    }
}

