/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.dao.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.dao.ConnectorsDao;
import org.restcomm.sbc.dao.DaoUtils;

@ThreadSafe
public final class MybatisConnectorsDao
implements ConnectorsDao {
    private static final String namespace = "org.restcomm.sbc.dao.ConnectorsDao.";
    private final SqlSessionFactory sessions;

    public MybatisConnectorsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector entry) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.restcomm.sbc.dao.ConnectorsDao.addEntry", (Object)this.toMap(entry));
            session.commit();
        }
    }

    public Connector getConnector(Sid sid) {
        Connector entry = null;
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("sid", sid.toString());
        entry = this.getConnector("org.restcomm.sbc.dao.ConnectorsDao.getEntry", parms);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connector getConnector(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, parameters);
            if (result != null) {
                Connector connector = this.toConnector(result);
                return connector;
            }
            Connector connector = null;
            return connector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connector> getConnectors() {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.sbc.dao.ConnectorsDao.getEntries");
            ArrayList<Connector> entrys = new ArrayList<Connector>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    entrys.add(this.toConnector(result));
                }
            }
            ArrayList<Connector> arrayList = entrys;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connector> getConnectorsByNetworkPoint(String pointId) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.sbc.dao.ConnectorsDao.getEntriesByNetworkPoint", (Object)pointId);
            ArrayList<Connector> entrys = new ArrayList<Connector>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    entrys.add(this.toConnector(result));
                }
            }
            ArrayList<Connector> arrayList = entrys;
            return arrayList;
        }
    }

    public void removeConnector(Sid sid) {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("sid", sid.toString());
        this.removeConnector("org.restcomm.sbc.dao.ConnectorsDao.updateEntry", parms);
    }

    public void updateConnector(Sid sid, String state) {
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put("sid", sid.toString());
        parms.put("state", state);
        this.updateConnector("org.restcomm.sbc.dao.ConnectorsDao.updateEntry", parms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnector(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, parameters);
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnector(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            session.update(selector, parameters);
            session.commit();
        }
    }

    private Connector toConnector(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid((Object)map.get("sid"));
        int port = DaoUtils.readInteger((Object)map.get("port"));
        String point = DaoUtils.readString((Object)map.get("n_point"));
        Sid entrySid = DaoUtils.readSid((Object)map.get("account_sid"));
        Connector.Transport transport = DaoUtils.readTransport((Object)map.get("transport"));
        Connector.State state = DaoUtils.readState((Object)map.get("state"));
        return new Connector(sid, entrySid, port, transport, point, state);
    }

    private Map<String, Object> toMap(Connector entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid((Sid)entry.getSid()));
        map.put("port", entry.getPort());
        map.put("transport", DaoUtils.writeTransport((Connector.Transport)entry.getTransport()));
        map.put("state", DaoUtils.writeState((Connector.State)entry.getState()));
        map.put("account_sid", DaoUtils.writeSid((Sid)entry.getAccountSid()));
        map.put("n_point", entry.getPoint());
        return map;
    }
}

