/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl.invite;

import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;

public class InviteProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(InviteProcessor.class);
    private String name = "INVITE Processor";

    public InviteProcessor(ProcessorChain chain) {
        super(chain);
        this.chain = chain;
    }

    public InviteProcessor(String name, ProcessorChain chain) {
        this(chain);
        this.setName(name);
    }

    private void processInviteRequest(SIPMutableMessage message) {
        SipServletRequest request = (SipServletRequest)message.getContent();
        message.setContent((Object)request);
    }

    private void processInviteResponse(SIPMutableMessage message) {
        SipServletResponse response = (SipServletResponse)message.getContent();
        if (response.getStatus() == 200) {
            message.setContent((Object)response);
        }
    }

    private void processByeRequest(SIPMutableMessage message) {
    }

    private void processAckRequest(SIPMutableMessage message) {
    }

    private void processPrackRequest(SIPMutableMessage message) {
    }

    private void processInfoRequest(SIPMutableMessage message) {
    }

    private void processCancelRequest(SIPMutableMessage message) {
    }

    private void processByeResponse(SIPMutableMessage message) {
    }

    private void processInfoResponse(SIPMutableMessage message) {
    }

    private void processCancelResponse(SIPMutableMessage message) {
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> doProcess()");
        }
        if (sm instanceof SipServletRequest) {
            if (sm.getMethod().equals("INVITE")) {
                this.processInviteRequest(m);
            } else if (sm.getMethod().equals("BYE")) {
                this.processByeRequest(m);
            } else if (sm.getMethod().equals("ACK")) {
                this.processAckRequest(m);
            } else if (sm.getMethod().equals("PRACK")) {
                this.processPrackRequest(m);
            } else if (sm.getMethod().equals("CANCEL")) {
                this.processCancelRequest(m);
            } else if (sm.getMethod().equals("INFO")) {
                this.processInfoRequest(m);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request METHOD " + sm.getMethod() + " not supported!"));
            }
        }
        if (sm instanceof SipServletResponse) {
            if (sm.getMethod().equals("INVITE")) {
                this.processInviteResponse(m);
            } else if (sm.getMethod().equals("BYE")) {
                this.processByeResponse(m);
            } else if (sm.getMethod().equals("CANCEL")) {
                this.processCancelResponse(m);
            } else if (sm.getMethod().equals("INFO")) {
                this.processInfoResponse(m);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Response METHOD " + sm.getMethod() + " not supported!"));
            }
        }
    }

    public String getVersion() {
        return "1.0.0";
    }
}

