/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import java.net.InetSocketAddress;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.managers.NetworkManager;

public class Connector {
    private Sid sid;
    private Sid accountSid;
    private int port;
    private State state;
    private Transport transport;
    private String point;
    private InetSocketAddress outboundInterface;

    public Connector(Sid sid, Sid accountSid, int port, Transport transport, String point, State state) {
        this.sid = sid;
        this.port = port;
        this.state = state;
        this.transport = transport;
        this.point = point;
        this.accountSid = accountSid;
        this.outboundInterface = new InetSocketAddress(NetworkManager.getIpAddress((String)point), port);
    }

    public Connector(int port, Transport transport, String point, State state) {
        this.port = port;
        this.state = state;
        this.transport = transport;
        this.point = point;
        this.outboundInterface = new InetSocketAddress(NetworkManager.getIpAddress((String)point), port);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public int getPort() {
        return this.port;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public State getState() {
        return this.state;
    }

    public String getPoint() {
        return this.point;
    }

    public String getHost() {
        return NetworkManager.getIpAddress((String)this.point);
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public Sid getSid() {
        return this.sid;
    }

    public Connector setPort(int port) {
        return new Connector(this.sid, this.accountSid, port, this.transport, this.point, this.state);
    }

    public Connector setTransport(Transport transPort) {
        return new Connector(this.sid, this.accountSid, this.port, this.transport, this.point, this.state);
    }

    public Connector setState(State state) {
        return new Connector(this.sid, this.accountSid, this.port, this.transport, this.point, state);
    }

    public Connector setPoint(String point) {
        return new Connector(this.sid, this.accountSid, this.port, this.transport, point, this.state);
    }

    public Connector setAccountSid(Sid accountSid) {
        return new Connector(this.sid, accountSid, this.port, this.transport, this.point, this.state);
    }

    public String toPrint() {
        return "[" + NetworkManager.getIpAddress((String)this.point) + ":" + this.transport + ":" + this.port + "] " + this.point + "/" + this.outboundInterface.toString() + ":" + this.state;
    }

    public InetSocketAddress getOutboundInterface() {
        return this.outboundInterface;
    }
}

