/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.servlet.sip;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.chain.impl.options.DownstreamOptionsProcessorChain;
import org.restcomm.sbc.chain.impl.options.UpstreamOptionsProcessorChain;
import org.restcomm.sbc.managers.RouteManager;

public class SBCOptionsServlet
extends SipServlet {
    private static final long serialVersionUID = 1L;
    private static transient Logger LOG = Logger.getLogger(SBCOptionsServlet.class);
    private UpstreamOptionsProcessorChain upChain;
    private DownstreamOptionsProcessorChain dwChain;

    public void init(ServletConfig servletConfig) throws ServletException {
        LOG.info((Object)"OPTIONS sip servlet has been started");
        super.init(servletConfig);
        this.upChain = new UpstreamOptionsProcessorChain();
        LOG.info((Object)("Loading (v. " + this.upChain.getVersion() + ") " + this.upChain.getName()));
        this.dwChain = new DownstreamOptionsProcessorChain();
        LOG.info((Object)("Loading (v. " + this.dwChain.getVersion() + ") " + this.dwChain.getName()));
    }

    protected void doOptions(SipServletRequest request) throws ServletException, IOException {
        if (RouteManager.isFromDMZ((SipServletMessage)request)) {
            this.upChain.process(new SIPMutableMessage((SipServletMessage)request));
        } else {
            this.dwChain.process(new SIPMutableMessage((SipServletMessage)request));
        }
    }

    protected void doResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
        super.doResponse(sipServletResponse);
    }
}

