/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.sip.restcomm.util.StringUtils;
import org.restcomm.sbc.bo.Location;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class LocationConverter
extends AbstractConverter
implements JsonSerializer<Location> {
    private final String apiVersion;
    private final String rootUri;

    public LocationConverter(Configuration configuration) {
        super(configuration);
        this.apiVersion = configuration.getString("api-version");
        this.rootUri = StringUtils.addSuffixIfNotPresent((String)configuration.getString("root-uri"), (String)"/");
    }

    @Override
    public boolean canConvert(Class klass) {
        return Location.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Location location = (Location)object;
        writer.startNode("Location");
        this.writeHost(location.getHost(), writer);
        this.writeUser(location.getUser(), writer);
        this.writeDomain(location.getDomain(), writer);
        this.writeTransport(location.getTransport(), writer);
        this.writeExpires(location.getExpires(), writer);
        this.writeUserAgent(location.getUserAgent(), writer);
        this.writePort((Integer)location.getPort(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Location location, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeUser(location.getUser(), object);
        this.writeHost(location.getHost(), object);
        this.writeDomain(location.getDomain(), object);
        this.writeTransport(location.getTransport(), object);
        this.writePort((Integer)location.getPort(), object);
        this.writeExpires(location.getExpires(), object);
        this.writeUserAgent(location.getUserAgent(), object);
        return object;
    }

    private void writeHost(String host, HierarchicalStreamWriter writer) {
        writer.startNode("Host");
        if (host != null) {
            writer.setValue(host);
        }
        writer.endNode();
    }

    private void writeHost(String host, JsonObject object) {
        object.addProperty("host", host);
    }

    private void writeDomain(String domain, HierarchicalStreamWriter writer) {
        writer.startNode("Domain");
        if (domain != null) {
            writer.setValue(domain);
        }
        writer.endNode();
    }

    private void writeDomain(String domain, JsonObject object) {
        object.addProperty("domain", domain);
    }

    private void writeUserAgent(String userAgent, HierarchicalStreamWriter writer) {
        writer.startNode("UserAgent");
        if (userAgent != null) {
            writer.setValue(userAgent);
        }
        writer.endNode();
    }

    private void writeUserAgent(String userAgent, JsonObject object) {
        object.addProperty("userAgent", userAgent);
    }

    private void writePort(Integer port, HierarchicalStreamWriter writer) {
        writer.startNode("Port");
        if (port != null) {
            writer.setValue(port.toString());
        }
        writer.endNode();
    }

    private void writePort(Integer port, JsonObject object) {
        object.addProperty("port", (Number)port);
    }

    private void writeUser(String user, HierarchicalStreamWriter writer) {
        writer.startNode("User");
        if (user != null) {
            writer.setValue(user);
        }
        writer.endNode();
    }

    private void writeUser(String user, JsonObject object) {
        object.addProperty("user", user);
    }

    private void writeTransport(String transport, HierarchicalStreamWriter writer) {
        writer.startNode("Transport");
        if (transport != null) {
            writer.setValue(transport);
        }
        writer.endNode();
    }

    private void writeTransport(String transport, JsonObject object) {
        if (transport != null) {
            object.addProperty("transport", transport);
        }
    }

    private void writeExpires(DateTime time, HierarchicalStreamWriter writer) {
        writer.startNode("Expires");
        if (time != null) {
            writer.setValue(time.toString());
        }
        writer.endNode();
    }

    private void writeExpires(DateTime time, JsonObject object) {
        if (time != null) {
            object.addProperty("expires", time.toString());
        }
    }
}

