/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.NotThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.bo.RestCommResponse;
import org.restcomm.sbc.bo.Route;
import org.restcomm.sbc.bo.RouteList;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.configuration.RestcommConfiguration;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.ConnectorsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.dao.NetworkPointsDao;
import org.restcomm.sbc.dao.RoutesDao;
import org.restcomm.sbc.managers.jmx.tomcat.Provider;
import org.restcomm.sbc.rest.SecuredEndpoint;
import org.restcomm.sbc.rest.converter.RestCommResponseConverter;
import org.restcomm.sbc.rest.converter.RouteConverter;
import org.restcomm.sbc.rest.converter.RouteListConverter;

@NotThreadSafe
public abstract class RoutesEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected DaoManager daos;
    protected Gson gson;
    protected GsonBuilder builder;
    protected XStream xstream;
    protected AccountsDao accountsDao;
    protected String instanceId;
    protected RouteListConverter listConverter;
    protected Provider jmxManager;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = this.daos.getAccountsDao();
        super.init(this.configuration);
        this.listConverter = new RouteListConverter(this.configuration);
        RouteConverter converter = new RouteConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(Route.class, (Object)converter);
        this.builder.registerTypeAdapter(RouteList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
    }

    protected Response getRoute(Sid sid, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Routes");
        RoutesDao dao = this.daos.getRoutesDao();
        Route route = dao.getRoute(sid);
        if (route == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, account.getSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(route);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)route), (String)"application/json").build();
        }
        return null;
    }

    protected Response deleteRoute(Sid sid) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Delete:Routes", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        RoutesDao dao = this.daos.getRoutesDao();
        Route route = dao.getRoute(sid);
        if (route == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        dao.removeRoute(sid);
        return Response.ok().build();
    }

    protected Response getRoutes(UriInfo info, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Routes");
        RoutesDao dao = this.daos.getRoutesDao();
        List<Route> routes = dao.getRoutes();
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(new RouteList(routes));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new RouteList(routes)), (String)"application/json").build();
        }
        return null;
    }

    private Route createFrom(String accountSid, MultivaluedMap<String, String> data) {
        Route.Builder builder = Route.builder();
        String sourceConnector = (String)data.getFirst((Object)"SourceConnectorSid");
        String targetConnector = (String)data.getFirst((Object)"TargetConnectorSid");
        builder.setSourceConnectorSid(new Sid(sourceConnector));
        builder.setTargetConnectorSid(new Sid(targetConnector));
        builder.setAccountSid(new Sid(accountSid));
        Sid sid = Sid.generate(Sid.Type.ROUTE);
        builder.setSid(sid);
        return builder.build();
    }

    protected Response putRoute(MultivaluedMap<String, String> data, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Modify:Routes");
        RoutesDao dao = this.daos.getRoutesDao();
        try {
            this.validate(data);
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        Route route = this.createFrom(account.getSid().toString(), data);
        dao.addRoute(route);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(route);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)route), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) {
        ConnectorsDao cdao = this.daos.getConnectorsDao();
        NetworkPointsDao ndao = this.daos.getNetworkPointDao();
        if (!data.containsKey((Object)"SourceConnectorSid")) {
            throw new NullPointerException("Source Connector can not be null.");
        }
        if (!data.containsKey((Object)"TargetConnectorSid")) {
            throw new NullPointerException("Target Connector can not be null.");
        }
        String ssid = (String)data.getFirst((Object)"SourceConnectorSid");
        String tsid = (String)data.getFirst((Object)"TargetConnectorSid");
        Connector sconnector = cdao.getConnector(new Sid(ssid));
        Connector tconnector = cdao.getConnector(new Sid(tsid));
        if (sconnector == null || tconnector == null) {
            throw new NullPointerException("Connector does not exist.");
        }
        NetworkPoint spoint = ndao.getNetworkPoint(sconnector.getPoint());
        NetworkPoint tpoint = ndao.getNetworkPoint(tconnector.getPoint());
        if (spoint == null || tpoint == null) {
            throw new NullPointerException("NetworkPoint does not exist.");
        }
        if (!spoint.getTag().allowRouting(tpoint.getTag())) {
            throw new IllegalArgumentException("No routable NetworkPoints. Check that source is DMZ owned and target MZ owned!");
        }
    }
}

