/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media.dtls;

import java.nio.channels.DatagramChannel;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.tls.DTLSServerProtocol;
import org.bouncycastle.crypto.tls.DatagramTransport;
import org.bouncycastle.crypto.tls.TlsServer;
import org.bouncycastle.crypto.tls.UDPTransport;
import org.mobicents.media.server.impl.rtp.crypto.PacketTransformer;
import org.mobicents.media.server.impl.rtp.crypto.SRTPPolicy;
import org.mobicents.media.server.impl.rtp.crypto.SRTPTransformEngine;
import org.mobicents.media.server.impl.srtp.DtlsListener;
import org.restcomm.sbc.media.dtls.DtlsSrtpServer;
import org.restcomm.sbc.media.dtls.DtlsSrtpServerProvider;

public class DtlsHandler {
    private static final AtomicLong THREAD_COUNTER = new AtomicLong(0L);
    private static final Logger logger = Logger.getLogger(DtlsHandler.class);
    public static final int DEFAULT_MTU = 1500;
    public static final int MAX_DELAY = 10000;
    private UDPTransport transport;
    private int mtu = 1500;
    private DtlsSrtpServer server;
    private DatagramChannel channel;
    private volatile boolean handshakeComplete;
    private volatile boolean handshakeFailed;
    private volatile boolean handshaking;
    private String localHashFunction;
    private String remoteHashFunction;
    private String remoteFingerprint;
    private String localFingerprint;
    private long startTime;
    private final List<DtlsListener> listeners;
    private PacketTransformer srtpEncoder;
    private PacketTransformer srtpDecoder;
    private PacketTransformer srtcpEncoder;
    private PacketTransformer srtcpDecoder;
    private DtlsSrtpServerProvider tlsServerProvider;

    public DtlsHandler(DtlsSrtpServerProvider tlsServerProvider) {
        this.server = tlsServerProvider.provide();
        this.handshakeComplete = false;
        this.handshakeFailed = false;
        this.handshaking = false;
        this.localHashFunction = "SHA-256";
        this.remoteHashFunction = "";
        this.remoteFingerprint = "";
        this.localFingerprint = "";
        this.startTime = 0L;
        this.listeners = new ArrayList<DtlsListener>();
        this.tlsServerProvider = tlsServerProvider;
    }

    public void setChannel(DatagramChannel channel) {
        this.channel = channel;
    }

    public void addListener(DtlsListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public boolean isHandshakeFailed() {
        return this.handshakeFailed;
    }

    public boolean isHandshaking() {
        return this.handshaking;
    }

    public String getLocalFingerprint() {
        if (this.localFingerprint == null || this.localFingerprint.isEmpty()) {
            this.localFingerprint = this.server.generateFingerprint(this.localHashFunction);
        }
        return this.localFingerprint;
    }

    public void resetLocalFingerprint() {
        this.localFingerprint = "";
    }

    public String getLocalHashFunction() {
        return this.localHashFunction;
    }

    public String getRemoteHashFunction() {
        return this.remoteHashFunction;
    }

    public String getRemoteFingerprintValue() {
        return this.remoteFingerprint;
    }

    public String getRemoteFingerprint() {
        return this.remoteHashFunction + " " + this.remoteFingerprint;
    }

    public void setRemoteFingerprint(String hashFunction, String fingerprint) {
        this.remoteHashFunction = hashFunction;
        this.remoteFingerprint = fingerprint;
    }

    private byte[] getMasterServerKey() {
        return this.server.getSrtpMasterServerKey();
    }

    private byte[] getMasterServerSalt() {
        return this.server.getSrtpMasterServerSalt();
    }

    private byte[] getMasterClientKey() {
        return this.server.getSrtpMasterClientKey();
    }

    private byte[] getMasterClientSalt() {
        return this.server.getSrtpMasterClientSalt();
    }

    private SRTPPolicy getSrtpPolicy() {
        return this.server.getSrtpPolicy();
    }

    private SRTPPolicy getSrtcpPolicy() {
        return this.server.getSrtcpPolicy();
    }

    public PacketTransformer getSrtpDecoder() {
        return this.srtpDecoder;
    }

    public PacketTransformer getSrtpEncoder() {
        return this.srtpEncoder;
    }

    public PacketTransformer getSrtcpDecoder() {
        return this.srtcpDecoder;
    }

    public PacketTransformer getSrtcpEncoder() {
        return this.srtcpEncoder;
    }

    private PacketTransformer generateRtpEncoder() {
        return new SRTPTransformEngine(this.getMasterServerKey(), this.getMasterServerSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTPTransformer();
    }

    private PacketTransformer generateRtpDecoder() {
        return new SRTPTransformEngine(this.getMasterClientKey(), this.getMasterClientSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTPTransformer();
    }

    private PacketTransformer generateRtcpEncoder() {
        return new SRTPTransformEngine(this.getMasterServerKey(), this.getMasterServerSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTCPTransformer();
    }

    private PacketTransformer generateRtcpDecoder() {
        return new SRTPTransformEngine(this.getMasterClientKey(), this.getMasterClientSalt(), this.getSrtpPolicy(), this.getSrtcpPolicy()).getRTCPTransformer();
    }

    public byte[] decodeRTP(byte[] packet, int offset, int length) {
        if (this.handshaking || this.srtpDecoder == null) {
            return packet;
        }
        return this.srtpDecoder.reverseTransform(packet, offset, length);
    }

    public byte[] encodeRTP(byte[] packet, int offset, int length) {
        if (this.handshaking || this.srtpEncoder == null) {
            return packet;
        }
        return this.srtpEncoder.transform(packet, offset, length);
    }

    public byte[] decodeRTCP(byte[] packet, int offset, int length) {
        return this.srtcpDecoder.reverseTransform(packet, offset, length);
    }

    public byte[] encodeRTCP(byte[] packet, int offset, int length) {
        return this.srtcpEncoder.transform(packet, offset, length);
    }

    public void handshake() {
        if (!this.handshaking && !this.handshakeComplete) {
            this.handshaking = true;
            this.startTime = System.currentTimeMillis();
            this.handshaker();
        }
    }

    private void fireHandshakeComplete() {
        if (this.listeners.size() > 0) {
            Iterator<DtlsListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDtlsHandshakeComplete();
            }
        }
    }

    private void fireHandshakeFailed(Throwable e) {
        if (this.listeners.size() > 0) {
            Iterator<DtlsListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDtlsHandshakeFailed(e);
            }
        }
    }

    public void reset() {
        this.server = this.tlsServerProvider.provide();
        this.channel = null;
        this.srtcpDecoder = null;
        this.srtcpEncoder = null;
        this.srtpDecoder = null;
        this.srtpEncoder = null;
        this.remoteHashFunction = "";
        this.remoteFingerprint = "";
        this.localFingerprint = "";
        this.handshakeComplete = false;
        this.handshakeFailed = false;
        this.handshaking = false;
        this.startTime = 0L;
        this.listeners.clear();
    }

    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        int contentType = packet[offset] & 0xFF;
        return contentType > 19 && contentType < 64;
    }

    private boolean hasTimeout() {
        return System.currentTimeMillis() - this.startTime > 10000L;
    }

    public void handshaker() {
        SecureRandom secureRandom = new SecureRandom();
        DTLSServerProtocol serverProtocol = new DTLSServerProtocol(secureRandom);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"DTLSHandler handshake started");
        }
        try {
            this.transport = new UDPTransport(this.channel.socket(), this.mtu);
            serverProtocol.accept((TlsServer)this.server, (DatagramTransport)this.transport);
            this.server.prepareSrtpSharedSecret();
            this.srtpDecoder = this.generateRtpDecoder();
            this.srtpEncoder = this.generateRtpEncoder();
            this.srtcpDecoder = this.generateRtcpDecoder();
            this.srtcpEncoder = this.generateRtcpEncoder();
            this.handshakeComplete = true;
            this.handshakeFailed = false;
            this.handshaking = false;
            this.fireHandshakeComplete();
        }
        catch (Exception e) {
            logger.error((Object)"DTLS handshake failed. Reason:", (Throwable)e);
            this.handshakeComplete = false;
            this.handshakeFailed = true;
            this.handshaking = false;
            this.fireHandshakeFailed(e);
        }
    }

    public UDPTransport getTransport() {
        return this.transport;
    }
}

