/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import org.apache.log4j.Logger;
import org.restcomm.sbc.ConfigurationCache;

public class PortManager {
    private static PortManager portManager;
    private static final Logger LOG;
    private static int startPort;
    private static int endPort;
    private int currentPort;

    private PortManager() {
        if (startPort == 0) {
            startPort = 10000;
        }
        if (endPort < startPort) {
            startPort = 10000;
            endPort = 20000;
        }
        if (startPort % 2 != 0) {
            ++startPort;
        }
        this.currentPort = startPort;
    }

    public static PortManager getPortManager() {
        if (portManager == null) {
            portManager = new PortManager();
        }
        return portManager;
    }

    public synchronized int getNextAvailablePort() {
        this.currentPort += 2;
        if (this.currentPort > endPort) {
            this.currentPort = startPort;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Assigning Media Port " + this.currentPort));
        }
        return this.currentPort;
    }

    public synchronized int getCurrentPort() {
        return this.currentPort;
    }

    static {
        LOG = Logger.getLogger(PortManager.class);
        startPort = ConfigurationCache.getMediaStartPort();
        endPort = ConfigurationCache.getMediaEndPort();
    }
}

