/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.crypto.RawPacket;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.media.MediaController;

public class MediaZone {
    protected static final int BUFFER = 1500;
    private static transient Logger LOG = Logger.getLogger(MediaZone.class);
    protected int originalRtpPort;
    protected int originalRtcpPort;
    protected boolean canMux;
    protected int rtpCountLog = ConfigurationCache.getRtpCountLog();
    protected String originalHost;
    protected String proxyHost;
    protected String mediaType;
    protected int logCounter = 0;
    protected boolean running;
    protected boolean suspended;
    protected MediaZone mediaZonePeer;
    protected ExecutorService executorService;
    protected DatagramChannel channel;
    protected DatagramSocket socket;
    protected int packetsSentCounter = 0;
    protected int packetsRecvCounter = 0;
    protected int lastPacketsSentCounter = 0;
    protected int lastPacketsRecvCounter = 0;
    protected int proxyPort;
    protected Direction direction;
    protected InetAddress proxyAddress;
    private InetAddress originalAddress;
    protected MediaController controller;
    byte[] buffer = new byte[1500];
    DatagramPacket dgram = new DatagramPacket(this.buffer, 1500);

    public MediaZone(MediaController controller, Direction direction, String mediaType, String originalHost, int originalRtpPort, int originalRtcpPort, boolean canMux, int proxyPort) throws UnknownHostException {
        this.controller = controller;
        this.originalHost = originalHost;
        this.originalRtpPort = originalRtpPort;
        this.originalRtcpPort = originalRtcpPort;
        this.canMux = canMux;
        this.mediaType = mediaType;
        this.direction = direction;
        this.proxyPort = proxyPort;
        this.originalAddress = InetAddress.getByName(originalHost);
    }

    public void setLocalProxy(String proxyHost) throws UnknownHostException, SocketException {
        this.proxyHost = proxyHost;
        InetSocketAddress address = new InetSocketAddress(proxyHost, this.proxyPort);
        try {
            this.channel = DatagramChannel.open();
            this.channel.bind(address);
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
        this.socket = this.channel.socket();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Opened socket " + address.toString() + " for " + this.toPrint()));
        }
        this.proxyAddress = address.getAddress();
        if (this.checkReady()) {
            this.fireProxyReadyEvent();
        } else {
            this.fireProxyFailedEvent();
        }
    }

    private synchronized boolean checkReady() {
        if (!this.isAttached()) {
            return false;
        }
        if (this.originalHost == null || this.originalRtpPort == 0) {
            return false;
        }
        return this.proxyHost != null && this.proxyPort != 0;
    }

    protected void fireProxyTimeoutEvent() {
        this.controller.getMediaSession().fireMediaTimeoutEvent(this);
    }

    protected void fireProxyTerminatedEvent() {
        this.controller.getMediaSession().fireMediaTerminatedEvent(this);
    }

    protected void fireProxyReadyEvent() {
        this.controller.getMediaSession().fireMediaReadyEvent(this);
    }

    protected void fireProxyFailedEvent() {
        this.controller.getMediaSession().fireMediaFailedEvent(this);
    }

    public int getOriginalRtpPort() {
        return this.originalRtpPort;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getOriginalHost() {
        return this.originalHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void start() throws UnknownHostException {
        if (this.isRunning()) {
            LOG.warn((Object)"Media Proxy is just running, silently ignoring");
            return;
        }
        if (!this.checkReady()) {
            LOG.warn((Object)("Media Zone could not stablish proper routes, should dismiss? " + this.toPrint()));
        }
        this.setRunning(true);
        this.executorService = Executors.newCachedThreadPool();
        this.executorService.execute(new Proxy());
        if (!this.mediaZonePeer.isRunning()) {
            this.mediaZonePeer.start();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Started " + this.isRunning() + "->" + this.toPrint()));
        }
    }

    public void suspend() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Suspending mediaZone " + this.toPrint()));
        }
        this.suspended = true;
    }

    public void resume() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Resuming mediaZone " + this.toPrint()));
        }
        this.suspended = false;
    }

    public void finalize() {
        this.setRunning(false);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Finalizing mediaZone " + this.toPrint()));
        }
        if (this.mediaZonePeer != null) {
            this.setRunning(false);
            if (this.mediaZonePeer.socket != null && !this.mediaZonePeer.socket.isClosed()) {
                this.mediaZonePeer.socket.close();
                this.mediaZonePeer.socket = null;
            }
            if (this.mediaZonePeer.executorService != null) {
                this.mediaZonePeer.executorService.shutdown();
                this.mediaZonePeer.executorService = null;
                this.mediaZonePeer.fireProxyTerminatedEvent();
                this.mediaZonePeer = null;
            }
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
            this.socket = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
            this.fireProxyTerminatedEvent();
        }
    }

    public String toPrint() {
        String value = "(UMZ " + (Object)((Object)this.direction) + ") " + this.hashCode() + " " + this.mediaType + ", Origin " + this.originalHost + ":" + this.originalRtpPort + ", LocalProxy " + this.proxyHost + ":" + this.proxyPort;
        if (this.mediaZonePeer != null) {
            value = value + "[(" + (Object)((Object)this.mediaZonePeer.direction) + ") " + this.mediaZonePeer.hashCode() + " " + this.mediaZonePeer.mediaType + ", Origin " + this.mediaZonePeer.originalHost + ":" + this.mediaZonePeer.originalRtpPort + ", LocalProxy " + this.mediaZonePeer.proxyHost + ":" + this.mediaZonePeer.proxyPort + "]";
        }
        return value;
    }

    public byte[] encodeRTP(byte[] data, int offset, int length) {
        return ArrayUtils.subarray((byte[])data, (int)offset, (int)length);
    }

    public byte[] decodeRTP(byte[] data, int offset, int length) {
        return ArrayUtils.subarray((byte[])data, (int)offset, (int)length);
    }

    public void send(DatagramPacket dgram) throws IOException {
        if (dgram == null) {
            return;
        }
        dgram.setAddress(this.mediaZonePeer.getOriginalAddress());
        dgram.setPort(this.mediaZonePeer.getOriginalRtpPort());
        if (dgram.getData().length > 8) {
            if (this.logCounter == this.rtpCountLog) {
                RawPacket rtp = new RawPacket(dgram.getData(), 0, dgram.getLength());
                LOG.trace((Object)("--->[PayloadType " + rtp.getPayloadType() + "](" + this.mediaType + ", " + (Object)((Object)this.direction) + ") LocalProxy " + this.proxyHost + ":" + this.proxyPort + "/" + dgram.getAddress() + ":" + dgram.getPort() + "[" + dgram.getLength() + "]"));
                this.logCounter = 0;
            }
        } else {
            LOG.warn((Object)("--->[PayloadType ?](" + this.mediaType + ", " + (Object)((Object)this.direction) + ") LocalProxy " + this.proxyHost + ":" + this.proxyPort + "/" + dgram.getAddress() + ":" + dgram.getPort() + "[" + dgram.getLength() + "]"));
        }
        ++this.packetsSentCounter;
        this.socket.send(dgram);
    }

    public DatagramPacket receive() throws IOException {
        if (this.mediaZonePeer.socket == null) {
            throw new IOException("NULL Socket on " + this.toPrint());
        }
        this.mediaZonePeer.socket.receive(this.dgram);
        if (this.dgram == null || this.dgram.getLength() < 8) {
            LOG.warn((Object)("RTPPacket too short, sending anyway " + this.dgram));
            return this.dgram;
        }
        this.dgram.setData(this.mediaZonePeer.encodeRTP(this.dgram.getData(), 0, this.dgram.getLength()));
        ++this.logCounter;
        if (this.logCounter == this.rtpCountLog) {
            RawPacket rtp = new RawPacket(this.dgram.getData(), 0, this.dgram.getLength());
            LOG.trace((Object)("<---[PayloadType " + rtp.getPayloadType() + "](" + this.mediaType + ", " + (Object)((Object)this.direction) + ") LocalProxy " + this.proxyHost + ":" + this.proxyPort + "/" + this.dgram.getAddress() + ":" + this.dgram.getPort() + "[" + this.dgram.getLength() + "]"));
        }
        ++this.packetsRecvCounter;
        return this.dgram;
    }

    public final void attach(MediaZone mediaZone) {
        if (!this.isAttached()) {
            this.setMediaZonePeer(mediaZone);
        }
        if (!mediaZone.isAttached()) {
            mediaZone.setMediaZonePeer(this);
        }
        if (this.checkReady()) {
            this.fireProxyReadyEvent();
        }
    }

    public boolean isAttached() {
        return this.mediaZonePeer != null;
    }

    public boolean isStreaming() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Packets stats on " + this.toPrint()));
            LOG.trace((Object)("Packets total/sent " + this.packetsSentCounter + "/" + this.lastPacketsSentCounter));
            LOG.trace((Object)("Packets total/recv " + this.packetsRecvCounter + "/" + this.lastPacketsRecvCounter));
        }
        if (this.packetsSentCounter > this.lastPacketsSentCounter && this.packetsRecvCounter > this.lastPacketsRecvCounter && this.packetsSentCounter > 0 && this.packetsRecvCounter > 0) {
            this.lastPacketsSentCounter = this.packetsSentCounter;
            this.lastPacketsRecvCounter = this.packetsRecvCounter;
            return true;
        }
        return false;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public MediaZone getMediaZonePeer() {
        return this.mediaZonePeer;
    }

    protected void setMediaZonePeer(MediaZone mediaZonePeer) {
        this.mediaZonePeer = mediaZonePeer;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    protected synchronized void setRunning(boolean running) {
        this.running = running;
    }

    public int getPacketsSentCounter() {
        return this.packetsSentCounter;
    }

    public int getPacketsRecvCounter() {
        return this.packetsRecvCounter;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean equals(Object zone) {
        MediaZone otherZone = (MediaZone)zone;
        if (!(zone instanceof MediaZone)) {
            return false;
        }
        return otherZone.getOriginalHost().equals(this.getOriginalHost()) && otherZone.getController().equals(this.getController()) && otherZone.getOriginalRtpPort() == this.getOriginalRtpPort() && otherZone.getMediaType().equals(this.getMediaType()) && otherZone.getDirection().equals((Object)this.getDirection());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.controller == null ? 0 : this.controller.hashCode());
        result = prime * result + (this.originalHost == null ? 0 : this.originalHost.hashCode());
        result = prime * result + (this.originalRtpPort == 0 ? 0 : this.originalRtpPort);
        result = prime * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = prime * result + (this.direction == null ? 0 : this.direction.hashCode());
        return result;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public InetAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public InetAddress getOriginalAddress() {
        return this.originalAddress;
    }

    public MediaController getController() {
        return this.controller;
    }

    public boolean canMux() {
        return this.canMux;
    }

    public static enum Direction {
        OFFER("*offer"),
        ANSWER("answer");

        private final String text;

        private Direction(String text) {
            this.text = text;
        }

        public static Direction getValueOf(String text) {
            Direction[] values;
            for (Direction value : values = Direction.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid call direction.");
        }

        public String toString() {
            return this.text;
        }
    }

    class Proxy
    implements Runnable {
        Proxy() {
        }

        @Override
        public void run() {
            while (MediaZone.this.isRunning()) {
                if (MediaZone.this.isSuspended()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                try {
                    MediaZone.this.send(MediaZone.this.receive());
                }
                catch (Exception e) {
                    if (MediaZone.this.isRunning() && MediaZone.this.mediaZonePeer.isRunning()) continue;
                    return;
                }
            }
        }
    }
}

