/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.restcomm.sbc.adapter.ProtocolAdapter;
import org.restcomm.sbc.adapter.UnavailableProtocolAdapterException;
import org.restcomm.sbc.adapter.impl.TCPProtocolAdapter;
import org.restcomm.sbc.adapter.impl.UDPProtocolAdapter;
import org.restcomm.sbc.adapter.impl.WSSProtocolAdapter;

public class ProtocolAdapterFactory {
    public static String PROTOCOL_UDP = "UDP";
    public static String PROTOCOL_TCP = "TCP";
    public static String PROTOCOL_SCTP = "SCTP";
    public static String PROTOCOL_TLS = "TLS";
    public static String PROTOCOL_WS = "WS";
    public static String PROTOCOL_WSS = "WSS";
    private static transient Logger LOG = Logger.getLogger(ProtocolAdapterFactory.class);
    private HashMap<String, ProtocolAdapter> protocols = new HashMap();
    private static ProtocolAdapterFactory protocolAdapterFactory;

    private ProtocolAdapterFactory() {
        this.registerRouter("UDP", new UDPProtocolAdapter());
        this.registerRouter("TCP", new TCPProtocolAdapter());
        this.registerRouter("WSS", new WSSProtocolAdapter());
    }

    public static ProtocolAdapterFactory getProtocolAdapterFactory() {
        if (protocolAdapterFactory == null) {
            protocolAdapterFactory = new ProtocolAdapterFactory();
        }
        return protocolAdapterFactory;
    }

    private void registerRouter(String toProtocol, ProtocolAdapter adapter) {
        this.protocols.put(toProtocol, adapter);
    }

    public ProtocolAdapter getAdapter(String protocol) throws UnavailableProtocolAdapterException {
        if (protocol == null) {
            throw new UnavailableProtocolAdapterException(protocol + " protocol adapter unavailable");
        }
        ProtocolAdapter adapter = this.protocols.get(protocol.toUpperCase());
        if (adapter == null) {
            throw new UnavailableProtocolAdapterException(protocol + " protocol adapter unavailable");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(">> Factoring ProtocolAdapter [" + adapter.getProtocol() + "]" + adapter));
        }
        return adapter;
    }
}

