/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.configuration;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.configuration.Configuration;
import org.restcomm.sbc.configuration.sets.ConfigurationSet;
import org.restcomm.sbc.configuration.sets.MainConfigurationSet;
import org.restcomm.sbc.configuration.sources.ApacheConfigurationSource;

public class RestcommConfiguration {
    private final Map<String, ConfigurationSet> sets = new ConcurrentHashMap<String, ConfigurationSet>();
    private static RestcommConfiguration instance;

    public RestcommConfiguration() {
    }

    public RestcommConfiguration(Configuration apacheConf) {
        this.addConfigurationSet("main", new MainConfigurationSet(new ApacheConfigurationSource(apacheConf)));
    }

    public void addConfigurationSet(String setKey, ConfigurationSet set) {
        this.sets.put(setKey, set);
    }

    public <T extends ConfigurationSet> T get(String key, Class<T> type) {
        return (T)((ConfigurationSet)type.cast(this.sets.get(key)));
    }

    public MainConfigurationSet getMain() {
        return (MainConfigurationSet)this.sets.get("main");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestcommConfiguration createOnce(Configuration apacheConf) {
        Class<RestcommConfiguration> clazz = RestcommConfiguration.class;
        synchronized (RestcommConfiguration.class) {
            if (instance == null) {
                instance = new RestcommConfiguration(apacheConf);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static RestcommConfiguration getInstance() {
        if (instance == null) {
            throw new IllegalStateException("RestcommConfiguration has not been initialized.");
        }
        return instance;
    }
}

