/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import java.net.Inet6Address;
import java.net.InetAddress;
import org.restcomm.sbc.bo.Sid;

public class NetworkPoint {
    private String id;
    private int group;
    private String description;
    private InetAddress address;
    private String macAddress;
    private InetAddress broadcast;
    private short prefixMask;
    private Tag tag;
    private Sid accountSid;

    public NetworkPoint(String id) {
        this.id = id;
        this.tag = Tag.IDLE;
    }

    public NetworkPoint(String id, Sid accountSid, Tag tag) {
        this.id = id;
        this.accountSid = accountSid;
        this.tag = tag;
    }

    public static Builder builder() {
        return new Builder();
    }

    public NetworkPoint setTag(Tag tag) {
        return new NetworkPoint(this.id, this.accountSid, tag);
    }

    public NetworkPoint setId(String id) {
        return new NetworkPoint(id, this.accountSid, this.tag);
    }

    public String getId() {
        return this.id;
    }

    public Tag getTag() {
        return this.tag;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public InetAddress getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(InetAddress broadcast) {
        this.broadcast = broadcast;
    }

    public short getPrefixMask() {
        return this.prefixMask;
    }

    public void setPrefixMask(short prefixMask) {
        this.prefixMask = prefixMask;
    }

    public String toPrint() {
        return "id=" + this.id + ", group=" + this.group + ", mac=" + this.macAddress + ", description=" + this.description + ", ip=" + this.address.getHostAddress() + ", ipv6 ?" + (this.address instanceof Inet6Address);
    }

    public static final class Builder {
        private String id;
        private Sid accountSid;
        private Tag tag;

        private Builder() {
        }

        public NetworkPoint build() {
            return new NetworkPoint(this.id, this.accountSid, this.tag);
        }

        public void setTag(Tag tag) {
            this.tag = tag;
        }

        public void setAccountSid(Sid sid) {
            this.accountSid = sid;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static enum Tag {
        DMZ("DMZ"),
        MZ("MZ"),
        IDLE("IDLE"),
        ORPHAN("ORPHAN");

        private final String text;

        private Tag(String text) {
            this.text = text;
        }

        public boolean isTagged() {
            switch (this) {
                case DMZ: 
                case MZ: {
                    return true;
                }
            }
            return false;
        }

        public boolean allowRouting(Tag tag) {
            return this == DMZ && tag == MZ;
        }

        public static Tag getValueOf(String text) {
            Tag[] values;
            for (Tag value : values = Tag.values()) {
                if (!value.toString().equals(text)) continue;
                return value;
            }
            throw new IllegalArgumentException(text + " is not a valid interface tag.");
        }

        public String toString() {
            return this.text;
        }
    }
}

