/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.Immutable;

@Immutable
public class BanListFilter {
    private final String action;
    private final String color;
    private final Date dateCreated;
    private final Date dateExpires;
    private final String ipAddress;
    private final String accountSid;
    private final String reason;
    private final Integer limit;
    private final Integer offset;
    private final String instanceid;

    public BanListFilter(String color, String ipAddress, String accountSid, String dateCreated, String dateExpires, String reason, String action, Integer limit, Integer offset) throws ParseException {
        this(color, ipAddress, accountSid, dateCreated, dateExpires, reason, action, limit, offset, null);
    }

    public BanListFilter(String color, String ipAddress, String accountSid, String dateCreated, String dateExpires, String reason, String action, Integer limit, Integer offset, String instanceId) throws ParseException {
        Date date;
        SimpleDateFormat parser;
        if (ipAddress != null) {
            ipAddress = "%".concat(ipAddress);
        }
        if (action != null) {
            action = "%".concat(action);
        }
        this.ipAddress = ipAddress;
        this.reason = reason;
        this.action = action;
        this.color = color;
        this.accountSid = accountSid;
        this.limit = limit;
        this.offset = offset;
        if (dateCreated != null) {
            parser = new SimpleDateFormat("yyyy-MM-dd");
            this.dateCreated = date = parser.parse(dateCreated);
        } else {
            this.dateCreated = null;
        }
        if (dateExpires != null) {
            parser = new SimpleDateFormat("yyyy-MM-dd");
            this.dateExpires = date = parser.parse(dateExpires);
        } else {
            this.dateExpires = null;
        }
        this.instanceid = instanceId != null && !instanceId.isEmpty() ? instanceId : null;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getInstanceid() {
        return this.instanceid;
    }

    public String getAction() {
        return this.action;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getDateExpires() {
        return this.dateExpires;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getAccountSid() {
        return this.accountSid;
    }

    public String getReason() {
        return this.reason;
    }

    public String getColor() {
        return this.color;
    }
}

