/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class ConferenceParticipantConverter
extends AbstractConverter
implements JsonSerializer<CallDetailRecord> {
    private final String apiVersion;
    private final String rootUri;

    public ConferenceParticipantConverter(Configuration configuration) {
        super(configuration);
        this.apiVersion = configuration.getString("api-version");
        this.rootUri = StringUtils.addSuffixIfNotPresent((String)configuration.getString("root-uri"), (String)"/");
    }

    @Override
    public boolean canConvert(Class klass) {
        return CallDetailRecord.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        CallDetailRecord cdr = (CallDetailRecord)object;
        writer.startNode("Call");
        this.writeSid(cdr.getSid(), writer);
        this.writeConferenceSid(cdr.getConferenceSid(), writer);
        this.writeDateCreated(cdr.getDateCreated(), writer);
        this.writeDateUpdated(cdr.getDateUpdated(), writer);
        this.writeAccountSid(cdr.getAccountSid(), writer);
        this.writeMuted(cdr.isMuted(), writer);
        this.writeHold(cdr.isOnHold(), writer);
        this.writeStartConferenceOnEnter(cdr.isStartConferenceOnEnter(), writer);
        this.writeEndConferenceOnEnter(cdr.isEndConferenceOnExit(), writer);
        this.writeUri(cdr.getUri(), writer);
        writer.endNode();
    }

    private String prefix(CallDetailRecord cdr) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.rootUri).append(this.apiVersion).append("/Accounts/");
        buffer.append(cdr.getAccountSid().toString()).append("/Calls/");
        buffer.append(cdr.getSid());
        return buffer.toString();
    }

    public JsonElement serialize(CallDetailRecord cdr, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(cdr.getSid(), object);
        this.writeConferenceSid(cdr.getParentCallSid(), object);
        this.writeDateCreated(cdr.getDateCreated(), object);
        this.writeDateUpdated(cdr.getDateUpdated(), object);
        this.writeAccountSid(cdr.getAccountSid(), object);
        this.writeMuted(cdr.isMuted(), object);
        this.writeHold(cdr.isOnHold(), object);
        this.writeStartConferenceOnEnter(cdr.isStartConferenceOnEnter(), object);
        this.writeEndConferenceOnEnter(cdr.isEndConferenceOnExit(), object);
        this.writeUri(cdr.getUri(), object);
        return object;
    }

    private void writeMuted(Boolean muted, HierarchicalStreamWriter writer) {
        writer.startNode("Muted");
        if (muted != null) {
            writer.setValue(muted.toString());
        }
        writer.endNode();
    }

    private void writeMuted(Boolean muted, JsonObject object) {
        object.addProperty("muted", muted);
    }

    private void writeHold(Boolean hold, HierarchicalStreamWriter writer) {
        writer.startNode("Hold");
        if (hold != null) {
            writer.setValue(hold.toString());
        }
        writer.endNode();
    }

    private void writeHold(Boolean hold, JsonObject object) {
        object.addProperty("hold", hold);
    }

    private void writeStartConferenceOnEnter(Boolean startConferenceOnEnter, HierarchicalStreamWriter writer) {
        writer.startNode("StartConferenceOnEnter");
        if (startConferenceOnEnter != null) {
            writer.setValue(startConferenceOnEnter.toString());
        }
        writer.endNode();
    }

    private void writeStartConferenceOnEnter(Boolean startConferenceOnEnter, JsonObject object) {
        object.addProperty("start_conference_on_enter", startConferenceOnEnter);
    }

    private void writeEndConferenceOnEnter(Boolean endConferenceOnEnter, HierarchicalStreamWriter writer) {
        writer.startNode("EndConferenceOnEnter");
        if (endConferenceOnEnter != null) {
            writer.setValue(endConferenceOnEnter.toString());
        }
        writer.endNode();
    }

    private void writeEndConferenceOnEnter(Boolean endConferenceOnEnter, JsonObject object) {
        object.addProperty("end_conference_on_enter", endConferenceOnEnter);
    }

    private void writeConferenceSid(Sid sid, HierarchicalStreamWriter writer) {
        writer.startNode("ConferenceSid");
        if (sid != null) {
            writer.setValue(sid.toString());
        }
        writer.endNode();
    }

    private void writeConferenceSid(Sid sid, JsonObject object) {
        if (sid != null) {
            object.addProperty("conference_sid", sid.toString());
        }
    }
}

