/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular.alt.forwardsecrecy;

import java.text.ParseException;
import org.refcodes.data.Text;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.forwardsecrecy.DecryptionProvider;
import org.refcodes.forwardsecrecy.NoCipherUidException;
import org.refcodes.forwardsecrecy.UnknownCipherUidException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.tabular.AbstractColumn;

public class DecryptionColumnImpl
extends AbstractColumn<String>
implements Cloneable {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private DecryptionProvider _decryptionProvider;

    public DecryptionColumnImpl(String aKey, DecryptionProvider aDecryptionProvider) {
        super(aKey, String.class);
        this._decryptionProvider = aDecryptionProvider;
    }

    public String[] toStorageStrings(String aValue) {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    public String fromStorageStrings(String[] aStringValues) throws ParseException {
        if (aStringValues == null || aStringValues.length == 0) {
            return null;
        }
        if (aStringValues.length == 1) {
            try {
                return this._decryptionProvider.toDecrypted(aStringValues[0]);
            }
            catch (UnknownCipherUidException e) {
                LOGGER.warn("Encountered an unkbwon cipher UID \"" + e.getUniversalId() + "\", unable to decrypt (returning encrypted value): \"" + ExceptionUtility.toMessage((Throwable)e) + "\" ...", (Throwable)e);
                return aStringValues[0];
            }
            catch (NoCipherUidException e) {
                LOGGER.warn("No cipher UID was foound for decryption (returning encrypted value): \"" + ExceptionUtility.toMessage((Throwable)e) + "\" ...", (Throwable)e);
                return aStringValues[0];
            }
        }
        throw new IllegalArgumentException("The type <" + this.getType().getName() + "> is not an array type though the number of elements in the provided string array is <" + aStringValues.length + "> whereas only one element is being expected.");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

