/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Literal;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.structure.PropertyImpl;

public class RuntimeUtilityTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static String[][] ARGS = new String[][]{{"--name", "NAME", "--boolean", "--active"}, {"--name", "NAME", "--boolean", "--alias", "ALIAS"}, {"--name", "NAME", "--boolean", "--alias", "ALIAS", "--active"}, {"--name", "NAME", "--boolean", "--alias", "ALIAS", "NULL"}, {"NULL", "--name", "NAME", "--boolean", "--alias", "ALIAS"}, {"NULL", "--name", "NAME", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "--name", "NAME0", "--name", "NAME1", "--boolean", "--alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "/name", "NAME1", "/boolean", "/alias", "ALIAS", "NIL"}, {"NULL", "-name", "NAME0", "-name", "NAME1", "-boolean", "-alias", "ALIAS", "NIL"}, {"NULL", "/name", "NAME0", "-name", "NAME1", "--boolean", "/alias", "ALIAS", "NIL"}};
    private static String[][] PROPERTIES = new String[][]{{"name=NAME", "boolean=true", "active=true"}, {"name=NAME", "boolean=true", "alias=ALIAS"}, {"name=NAME", "boolean=true", "alias=ALIAS", "active=true"}, {"name=NAME", "boolean=true", "alias=ALIAS", "null=NULL"}, {"null=NULL", "name=NAME", "boolean=true", "alias=ALIAS"}, {"name=NAME", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}, {"name#0=NAME0", "name#1=NAME1", "boolean=true", "alias=ALIAS", "null#0=NULL", "null#1=NIL"}};

    @Test
    public void testIsUnderTest() {
        Assertions.assertTrue((boolean)RuntimeUtility.isUnderTest());
    }

    @Test
    public void testGetStackTraceElement() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        String theFullyQualifiedMethodName = RuntimeUtility.toFullyQualifiedMethodName((StackTraceElement)theStackTraceElement);
        if (IS_LOG_TESTS) {
            System.out.println(theFullyQualifiedMethodName);
        }
        Assertions.assertEquals((Object)(RuntimeUtilityTest.class.getName() + Delimiter.METHOD_NAME.getChar() + "testGetStackTraceElement"), (Object)theFullyQualifiedMethodName);
    }

    @Test
    public void testToFullyQualifiedMethodName() {
        StackTraceElement theStackTraceElement = RuntimeUtility.getCallerStackTraceElement(RuntimeUtilityTest.class);
        String theFullyQualifiedMethodName = RuntimeUtility.toFullyQualifiedMethodName((StackTraceElement)theStackTraceElement);
        Assertions.assertNotEquals((Object)(RuntimeUtilityTest.class.getName() + Delimiter.METHOD_NAME.getChar() + "testToFullyQualifiedMethodName"), (Object)theFullyQualifiedMethodName);
    }

    @Test
    public void testToFullyQualifiedPackageName() {
        String thePackageName = RuntimeUtility.toFullyQualifiedPackageName();
        Assertions.assertEquals((Object)thePackageName, (Object)this.getClass().getPackage().getName());
    }

    @Test
    public void testToClassName() {
        String theClassName = RuntimeUtility.toClassName();
        Assertions.assertEquals((Object)theClassName, (Object)this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        String theFooBar = "FooBar";
        String theFullyQualifiedClassName = "foo.bar." + theFooBar;
        if (IS_LOG_TESTS) {
            System.out.println(theFullyQualifiedClassName + " --> toClassName() --> " + RuntimeUtility.toClassName((String)theFullyQualifiedClassName));
        }
        Assertions.assertEquals((Object)theFooBar, (Object)RuntimeUtility.toClassName((String)theFullyQualifiedClassName));
    }

    @Test
    public void testToInnerClassName() {
        String theClassName = RuntimeUtility.toClassName();
        Assertions.assertEquals((Object)theClassName, (Object)this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        String theInnerFooBar = "InnerFooBar";
        String theFullyQualifiedClassName = "foo.bar.FooBar$" + theInnerFooBar;
        if (IS_LOG_TESTS) {
            System.out.println(theFullyQualifiedClassName + " --> toClassName() --> " + RuntimeUtility.toClassName((String)theFullyQualifiedClassName));
        }
        Assertions.assertEquals((Object)theInnerFooBar, (Object)RuntimeUtility.toClassName((String)theFullyQualifiedClassName));
    }

    @Test
    public void testGetPid() {
        if (IS_LOG_TESTS) {
            System.out.println("PID = " + RuntimeUtility.getPid());
        }
    }

    @Test
    public void testToApplicationBaseFile() throws IOException {
        File theFile = RuntimeUtility.toLauncherDir();
        if (IS_LOG_TESTS) {
            System.out.println("Application base file = " + theFile.toURI().toURL().toString());
        }
    }

    @Test
    public void testGetMainClass() throws IOException {
        Class theMainClass = RuntimeUtility.getMainClass();
        if (IS_LOG_TESTS) {
            System.out.println("Main class = " + theMainClass.getName());
        }
    }

    @Test
    public void testArgsProperties() {
        for (int i = 0; i < ARGS.length; ++i) {
            this.testArgs(i);
        }
    }

    @Disabled
    @Test
    public void testEdgeCase() {
        this.testArgs(7);
    }

    protected void testArgs(int i) {
        Map theProperties = RuntimeUtility.toProperties((String[])ARGS[i]);
        if (IS_LOG_TESTS) {
            System.out.println("Line <" + i + ">:");
        }
        for (String eKey : theProperties.keySet()) {
            if (!IS_LOG_TESTS) continue;
            System.out.println(eKey + " = " + (String)theProperties.get(eKey));
        }
        String[] theExcepcted = PROPERTIES[i];
        for (int j = 0; j < theExcepcted.length; ++j) {
            PropertyImpl eProperty = new PropertyImpl(theExcepcted[j]);
            if (((String)eProperty.getKey()).equals(Literal.NULL.getName())) {
                eProperty = new PropertyImpl(null, (String)eProperty.getValue());
            }
            Assertions.assertEquals((Object)eProperty.getValue(), theProperties.get(eProperty.getKey()), (String)("Line <" + i + "> (" + eProperty.toString() + ")"));
        }
    }
}

