/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.impls;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.net.BadResponseException;
import org.refcodes.net.HttpMediaType;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpServerResponse;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.MediaType;
import org.refcodes.net.RequestCookie;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.impls.ApplicationJsonFactory;
import org.refcodes.net.impls.RequestHeaderFieldsImpl;
import org.refcodes.rest.LoopbackRestServer;
import org.refcodes.rest.impls.LoopbackRestServerImpl;

public class LoopbackRestServerTest {
    private static final String LOCATOR = "/bla";
    private static final String BASE_LOCATOR = "/refcodes";
    private static final String COOKIE_A_NAME = "refcodes";
    private static final String COOKIE_A_VALUE = "org";
    private static final String COOKIE_A_VALUE_2 = "com";
    private static final String COOKIE_B_NAME = "funcodes";
    private static final String COOKIE_B_VALUE = "forever";
    private static final String LAST_NAME = "Bushnell";
    private static final String FIRST_NAME = "Nolan";

    @Test
    public void testLoopbackRestServer() throws IOException, HttpStatusException, MarshalException, BadResponseException, UnmarshalException {
        LoopbackRestServer theRestServer = new LoopbackRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        ApplicationJsonFactory theFactory = new ApplicationJsonFactory();
        RequestHeaderFields theHeaderFields = (RequestHeaderFields)new RequestHeaderFieldsImpl().withAcceptTypes(new HttpMediaType[]{MediaType.APPLICATION_JSON});
        HttpServerResponse theResponse = theRestServer.onHttpRequest(null, null, HttpMethod.POST, "/refcodes/bla", null, theHeaderFields, theFactory.fromUnmarshaled((Object)new Person(FIRST_NAME, LAST_NAME)));
        Person thePerson = (Person)theFactory.toUnmarshaled((Object)theResponse.toHttpBody(), Person.class);
        Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
        Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
    }

    @Test
    public void testServerCookie() throws IOException, HttpStatusException, MarshalException, BadResponseException, UnmarshalException {
        LoopbackRestServer theRestServer = new LoopbackRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            RequestCookie theCookie = (RequestCookie)((RequestHeaderFields)aRequest.getHeaderFields()).getFirstCookie(COOKIE_A_NAME);
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)theCookie.getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE, (Object)theCookie.getValue());
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        ApplicationJsonFactory theFactory = new ApplicationJsonFactory();
        RequestHeaderFields theHeaderFields = (RequestHeaderFields)new RequestHeaderFieldsImpl().withAcceptTypes(new HttpMediaType[]{MediaType.APPLICATION_JSON});
        theHeaderFields.addCookie(COOKIE_A_NAME, COOKIE_A_VALUE);
        HttpServerResponse theResponse = theRestServer.onHttpRequest(null, null, HttpMethod.POST, "/refcodes/bla", null, theHeaderFields, theFactory.fromUnmarshaled((Object)new Person(FIRST_NAME, LAST_NAME)));
        Person thePerson = (Person)theFactory.toUnmarshaled((Object)theResponse.toHttpBody(), Person.class);
        Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
        Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
    }

    @Test
    public void testServerCookies() throws IOException, BadResponseException, UnmarshalException, HttpStatusException, MarshalException {
        LoopbackRestServer theRestServer = new LoopbackRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
            List theCookies = ((RequestHeaderFields)aRequest.getHeaderFields()).getAllCookies();
            Assert.assertEquals((String)"Expecting two cookies", (long)2L, (long)theCookies.size());
            int a = 0;
            int b = 1;
            if (((String)((RequestCookie)theCookies.get(a)).getValue()).equals(COOKIE_A_VALUE_2)) {
                a = 1;
                b = 0;
            }
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)((RequestCookie)theCookies.get(a)).getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE, (Object)((RequestCookie)theCookies.get(a)).getValue());
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)((RequestCookie)theCookies.get(b)).getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE_2, (Object)((RequestCookie)theCookies.get(b)).getValue());
        }).open();
        ApplicationJsonFactory theFactory = new ApplicationJsonFactory();
        RequestHeaderFields theHeaderFields = (RequestHeaderFields)new RequestHeaderFieldsImpl().withAcceptTypes(new HttpMediaType[]{MediaType.APPLICATION_JSON});
        theHeaderFields.addCookie(COOKIE_A_NAME, COOKIE_A_VALUE);
        theHeaderFields.addCookie(COOKIE_A_NAME, COOKIE_A_VALUE_2);
        HttpServerResponse theResponse = theRestServer.onHttpRequest(null, null, HttpMethod.POST, "/refcodes/bla", null, theHeaderFields, theFactory.fromUnmarshaled((Object)new Person(FIRST_NAME, LAST_NAME)));
        Person thePerson = (Person)theFactory.toUnmarshaled((Object)theResponse.toHttpBody(), Person.class);
        Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
        Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
    }

    @Test
    public void testAllServerCookies() throws IOException, BadResponseException, UnmarshalException, HttpStatusException, MarshalException {
        LoopbackRestServer theRestServer = new LoopbackRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
            List theCookies = ((RequestHeaderFields)aRequest.getHeaderFields()).getAllCookies();
            Assert.assertEquals((String)"Expecting two cookies", (long)2L, (long)theCookies.size());
            int a = 0;
            int b = 1;
            if (((String)((RequestCookie)theCookies.get(a)).getKey()).equals(COOKIE_B_NAME)) {
                a = 1;
                b = 0;
            }
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)((RequestCookie)theCookies.get(a)).getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE, (Object)((RequestCookie)theCookies.get(a)).getValue());
            Assert.assertEquals((Object)COOKIE_B_NAME, (Object)((RequestCookie)theCookies.get(b)).getKey());
            Assert.assertEquals((Object)COOKIE_B_VALUE, (Object)((RequestCookie)theCookies.get(b)).getValue());
        }).open();
        ApplicationJsonFactory theFactory = new ApplicationJsonFactory();
        RequestHeaderFields theHeaderFields = (RequestHeaderFields)new RequestHeaderFieldsImpl().withAcceptTypes(new HttpMediaType[]{MediaType.APPLICATION_JSON});
        theHeaderFields.addCookie(COOKIE_A_NAME, COOKIE_A_VALUE);
        theHeaderFields.addCookie(COOKIE_B_NAME, COOKIE_B_VALUE);
        HttpServerResponse theResponse = theRestServer.onHttpRequest(null, null, HttpMethod.POST, "/refcodes/bla", null, theHeaderFields, (String)theFactory.toMarshaled((Object)new Person(FIRST_NAME, LAST_NAME)));
        Person thePerson = (Person)theFactory.toUnmarshaled((Object)theResponse.toHttpBody(), Person.class);
        Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
        Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
    }

    public static class Person {
        private String firstName;
        private String lastName;

        public String toString() {
            return "Person [firstName=" + this.firstName + ", lastName=" + this.lastName + "]";
        }

        public Person() {
        }

        public Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

