/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest.impls;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.net.FormFields;
import org.refcodes.net.HttpBodyMap;
import org.refcodes.net.HttpMediaType;
import org.refcodes.net.HttpMethod;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.MediaType;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.ResponseCookie;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.net.impls.FormFieldsImpl;
import org.refcodes.net.impls.PortManagerSingleton;
import org.refcodes.rest.HttpRestClient;
import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.RestCallerBuilder;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.impls.HttpRestClientImpl;
import org.refcodes.rest.impls.HttpRestServerImpl;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.impls.HorizAlignTextBuilderImpl;

public class HttpRestClientTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final int MOD_BYTE = 256;
    private static final String LOCATOR = "/bla";
    private static final String BASE_URL = "http://localhost";
    private static final String BASE_LOCATOR = "/refcodes";
    private static final String COOKIE_A_PATH = "/refcodes/bla";
    private static final String COOKIE_A_NAME = "refcodes";
    private static final String COOKIE_A_VALUE = "org";
    private static final String COOKIE_A_VALUE_2 = "com";
    private static final String COOKIE_B_PATH = "/refcodes/blub";
    private static final String COOKIE_B_NAME = "funcodes";
    private static final String COOKIE_B_VALUE = "forever";
    private static final String LAST_NAME = "Bushnell";
    private static final String FIRST_NAME = "Nolan";
    private static final String KEY_LAST_NAME = "lastName";
    private static final String KEY_FIRST_NAME = "firstName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsynchtronousRestClient() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            LOGGER.debug(thePerson.toString());
            theRestServer.closeQuietly();
            HttpRestClientTest httpRestClientTest = this;
            synchronized (httpRestClientTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME)).open();
        HttpRestClientTest httpRestClientTest = this;
        synchronized (httpRestClientTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsynchtronousRestClient2() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, (Object)new Person(FIRST_NAME, LAST_NAME), aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            LOGGER.debug(thePerson.toString());
            theRestServer.closeQuietly();
            HttpRestClientTest httpRestClientTest = this;
            synchronized (httpRestClientTest) {
                this.notifyAll();
            }
        }).open();
        HttpRestClientTest httpRestClientTest = this;
        synchronized (httpRestClientTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    @Test
    public void testSynchtronousRestClient() throws IOException, HttpResponseException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestResponse aResponse2 = theRestClient.doRequest(HttpMethod.POST, LOCATOR, (Object)new Person(FIRST_NAME, LAST_NAME));
        Person thePerson = (Person)aResponse2.getResponse(Person.class);
        LOGGER.debug(thePerson.toString());
        theRestServer.closeQuietly();
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    @Test
    public void testResponseBuilderOverClient() throws IOException, HttpResponseException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestResponse theResponse = theRestClient.buildRequest(HttpMethod.POST, LOCATOR, (Object)new Person(FIRST_NAME, LAST_NAME)).toRestResponse();
        Person thePerson = (Person)theResponse.getResponse(Person.class);
        LOGGER.debug(thePerson.toString());
        theRestServer.closeQuietly();
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientCookie() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
            ((ResponseCookie)((ResponseHeaderFields)aResponse.getHeaderFields()).addCookie(COOKIE_A_NAME, COOKIE_A_VALUE)).withPath(COOKIE_A_PATH);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            ResponseCookie theCookie = (ResponseCookie)((ResponseHeaderFields)aResponse.getHeaderFields()).getFirstCookie(COOKIE_A_NAME);
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)theCookie.getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE, (Object)theCookie.getValue());
            Assert.assertEquals((Object)COOKIE_A_PATH, (Object)theCookie.getPath());
            theRestServer.closeQuietly();
            HttpRestClientTest httpRestClientTest = this;
            synchronized (httpRestClientTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME)).open();
        HttpRestClientTest httpRestClientTest = this;
        synchronized (httpRestClientTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientCookies() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
            ((ResponseCookie)((ResponseHeaderFields)aResponse.getHeaderFields()).addCookie(COOKIE_A_NAME, COOKIE_A_VALUE)).withPath(COOKIE_A_PATH);
            ((ResponseCookie)((ResponseHeaderFields)aResponse.getHeaderFields()).addCookie(COOKIE_A_NAME, COOKIE_A_VALUE_2)).withPath(COOKIE_A_PATH);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            List theCookies = ((ResponseHeaderFields)aResponse.getHeaderFields()).getCookies(COOKIE_A_NAME);
            Assert.assertEquals((String)"Expecting two cookies", (long)2L, (long)theCookies.size());
            int a = 0;
            int b = 1;
            if (((String)((ResponseCookie)theCookies.get(a)).getValue()).equals(COOKIE_A_VALUE_2)) {
                a = 1;
                b = 0;
            }
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)((ResponseCookie)theCookies.get(a)).getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE, (Object)((ResponseCookie)theCookies.get(a)).getValue());
            Assert.assertEquals((Object)COOKIE_A_PATH, (Object)((ResponseCookie)theCookies.get(a)).getPath());
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)((ResponseCookie)theCookies.get(b)).getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE_2, (Object)((ResponseCookie)theCookies.get(b)).getValue());
            Assert.assertEquals((Object)COOKIE_A_PATH, (Object)((ResponseCookie)theCookies.get(b)).getPath());
            theRestServer.closeQuietly();
            HttpRestClientTest httpRestClientTest = this;
            synchronized (httpRestClientTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME)).open();
        HttpRestClientTest httpRestClientTest = this;
        synchronized (httpRestClientTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllClientCookies() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            Person thePerson = (Person)aRequest.getRequest(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            aResponse.setResponse((Object)thePerson);
            ((ResponseCookie)((ResponseHeaderFields)aResponse.getHeaderFields()).addCookie(COOKIE_A_NAME, COOKIE_A_VALUE)).withPath(COOKIE_A_PATH);
            ((ResponseCookie)((ResponseHeaderFields)aResponse.getHeaderFields()).addCookie(COOKIE_B_NAME, COOKIE_B_VALUE)).withPath(COOKIE_B_PATH);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            Person thePerson = (Person)aResponse.getResponse(Person.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.getLastName());
            List theCookies = ((ResponseHeaderFields)aResponse.getHeaderFields()).getAllCookies();
            Assert.assertEquals((String)"Expecting two cookies", (long)2L, (long)theCookies.size());
            int a = 0;
            int b = 1;
            if (((String)((ResponseCookie)theCookies.get(a)).getKey()).equals(COOKIE_B_NAME)) {
                a = 1;
                b = 0;
            }
            Assert.assertEquals((Object)COOKIE_A_NAME, (Object)((ResponseCookie)theCookies.get(a)).getKey());
            Assert.assertEquals((Object)COOKIE_A_VALUE, (Object)((ResponseCookie)theCookies.get(a)).getValue());
            Assert.assertEquals((Object)COOKIE_A_PATH, (Object)((ResponseCookie)theCookies.get(a)).getPath());
            Assert.assertEquals((Object)COOKIE_B_NAME, (Object)((ResponseCookie)theCookies.get(b)).getKey());
            Assert.assertEquals((Object)COOKIE_B_VALUE, (Object)((ResponseCookie)theCookies.get(b)).getValue());
            Assert.assertEquals((Object)COOKIE_B_PATH, (Object)((ResponseCookie)theCookies.get(b)).getPath());
            theRestServer.closeQuietly();
            HttpRestClientTest httpRestClientTest = this;
            synchronized (httpRestClientTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new Person(FIRST_NAME, LAST_NAME)).open();
        HttpRestClientTest httpRestClientTest = this;
        synchronized (httpRestClientTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebForm() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            FormFields theFormFields = (FormFields)aRequest.getRequest(FormFields.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)theFormFields.getFirst(KEY_FIRST_NAME));
            Assert.assertEquals((Object)LAST_NAME, (Object)theFormFields.getFirst(KEY_LAST_NAME));
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        FormFields theWebForm = (FormFields)((FormFields)new FormFieldsImpl().withAddTo(KEY_FIRST_NAME, FIRST_NAME)).withAddTo(KEY_LAST_NAME, LAST_NAME);
        RestCallerBuilder theCaller = theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            theRestServer.closeQuietly();
            HttpRestClientTest httpRestClientTest = this;
            synchronized (httpRestClientTest) {
                this.notifyAll();
            }
        }).withRequest((Object)theWebForm);
        ((RequestHeaderFields)theCaller.getHeaderFields()).putContentType((HttpMediaType)MediaType.APPLICATION_X_WWW_FORM_URLENCODED);
        theCaller.open();
        HttpRestClientTest httpRestClientTest = this;
        synchronized (httpRestClientTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpRestClientStreamA() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            InputStream theInputStream = (InputStream)aRequest.getRequest(InputStream.class);
            try {
                int i = 0;
                int theCounter = 0;
                StringBuffer theBuffer = new StringBuffer();
                while (theInputStream.available() > 0) {
                    int eByte = theInputStream.read();
                    Assert.assertEquals((long)(theCounter % 256), (long)eByte);
                    ++theCounter;
                    theBuffer.append(String.valueOf(new HorizAlignTextBuilderImpl().withColumnWidth(3).withFillChar('0').withHorizAlignTextMode(HorizAlignTextMode.RIGHT).toString(new String[]{String.valueOf(eByte)})) + " ");
                    if (++i <= 10 && theInputStream.available() != 0) continue;
                    LOGGER.info(theBuffer.toString());
                    i = 0;
                    theBuffer = new StringBuffer();
                }
            }
            catch (Exception e) {
                Assert.fail();
            }
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            theRestServer.closeQuietly();
            HttpRestClientTest httpRestClientTest = this;
            synchronized (httpRestClientTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new NumberSequenceInputStream()).open();
        HttpRestClientTest httpRestClientTest = this;
        synchronized (httpRestClientTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpRestClientStreamB() throws IOException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> aResponse.setResponse((Object)((InputStream)aRequest.getRequest(InputStream.class)))).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        theRestClient.doRequest(HttpMethod.POST, LOCATOR, aResponse -> {
            InputStream theInputStream = (InputStream)aResponse.getResponse(InputStream.class);
            try {
                int i = 0;
                int theCounter = 0;
                StringBuffer theBuffer = new StringBuffer();
                while (theInputStream.available() > 0) {
                    int eByte = theInputStream.read();
                    Assert.assertEquals((long)(theCounter % 256), (long)eByte);
                    ++theCounter;
                    theBuffer.append(String.valueOf(new HorizAlignTextBuilderImpl().withColumnWidth(3).withFillChar('0').withHorizAlignTextMode(HorizAlignTextMode.RIGHT).toString(new String[]{String.valueOf(eByte)})) + " ");
                    if (++i <= 10 && theInputStream.available() != 0) continue;
                    LOGGER.info(theBuffer.toString());
                    i = 0;
                    theBuffer = new StringBuffer();
                }
            }
            catch (Exception e) {
                Assert.fail();
            }
            theRestServer.closeQuietly();
            HttpRestClientTest httpRestClientTest = this;
            synchronized (httpRestClientTest) {
                this.notifyAll();
            }
        }).withRequest((Object)new NumberSequenceInputStream()).open();
        HttpRestClientTest httpRestClientTest = this;
        synchronized (httpRestClientTest) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    @Test
    public void testHttpBodyMap1() throws IOException, HttpResponseException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            HttpBodyMap thePerson = (HttpBodyMap)aRequest.getRequest(HttpBodyMap.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.get((Object)"/firstName"));
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.get((Object)"/lastName"));
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestResponse aResponse2 = theRestClient.doRequest(HttpMethod.POST, LOCATOR, (Object)new Person(FIRST_NAME, LAST_NAME));
        Person thePerson = (Person)aResponse2.getResponse(Person.class);
        LOGGER.debug(thePerson.toString());
        theRestServer.closeQuietly();
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    @Test
    public void testHttpBodyMap2() throws IOException, HttpResponseException {
        Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
        LOGGER.info("Using port <" + thePort + "> for testing ...");
        HttpRestServer theRestServer = new HttpRestServerImpl().withBaseLocator(BASE_LOCATOR);
        theRestServer.onPost(LOCATOR, (aRequest, aResponse) -> {
            HttpBodyMap thePerson = (HttpBodyMap)aRequest.getRequest(HttpBodyMap.class);
            Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.get((Object)"/firstName"));
            Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.get((Object)"/lastName"));
            aResponse.setResponse((Object)thePerson);
        }).open();
        theRestServer.open((Object)thePort);
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl(this.toBaseUrl(thePort));
        RestResponse aResponse2 = theRestClient.doRequest(HttpMethod.POST, LOCATOR, (Object)new Person(FIRST_NAME, LAST_NAME));
        HttpBodyMap thePerson = (HttpBodyMap)aResponse2.getResponse(HttpBodyMap.class);
        LOGGER.debug(thePerson.toString());
        Assert.assertEquals((Object)FIRST_NAME, (Object)thePerson.get((Object)"/firstName"));
        Assert.assertEquals((Object)LAST_NAME, (Object)thePerson.get((Object)"/lastName"));
        theRestServer.closeQuietly();
        PortManagerSingleton.getInstance().unbindPort(thePort);
    }

    @Ignore
    @Test
    public void testEdgeCase() throws IOException, HttpResponseException {
        HttpRestClient theRestClient = (HttpRestClient)new HttpRestClientImpl().withBaseUrl("https://www.heise.de");
        RestResponse theResponse = theRestClient.doGet("thema/Linux-und-Open-Source");
        System.out.println(theResponse.getHttpBody());
    }

    private String toBaseUrl(Integer thePort) {
        return "http://localhost:" + thePort + BASE_LOCATOR;
    }

    private static class NumberSequenceInputStream
    extends InputStream {
        private int _counter = 0;

        private NumberSequenceInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (this.available() <= 0) {
                return -1;
            }
            return this._counter++ % 256;
        }

        @Override
        public int available() throws IOException {
            return 1024 - this._counter;
        }
    }

    public static class Person {
        private String firstName;
        private String lastName;

        public String toString() {
            return "Person [firstName=" + this.firstName + ", lastName=" + this.lastName + "]";
        }

        public Person() {
        }

        public Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

