/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.redisson.config.DelayStrategy;

public class DecorrelatedJitterDelay
implements DelayStrategy {
    private final Duration minDelay;
    private final Duration maxDelay;
    private Duration previousDelay;

    public DecorrelatedJitterDelay(Duration minDelay, Duration maxDelay) {
        Objects.requireNonNull(minDelay);
        Objects.requireNonNull(maxDelay);
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.previousDelay = Duration.ZERO;
    }

    @Override
    public Duration calcDelay(int attempt) {
        long previousMs = this.previousDelay.isZero() ? this.minDelay.toMillis() : this.previousDelay.toMillis();
        long randomRange = previousMs * 3L;
        long randomComponent = 0L;
        if (randomRange != 0L) {
            randomComponent = ThreadLocalRandom.current().nextLong(0L, randomRange);
        }
        long newDelayMs = Math.min(this.minDelay.toMillis() + randomComponent, this.maxDelay.toMillis());
        this.previousDelay = Duration.ofMillis(newDelayMs);
        return this.previousDelay;
    }
}

