/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.vector;

import org.redisson.api.vector.VectorSimilarArgs;

public final class VectorSimilarParams
implements VectorSimilarArgs {
    private final String element;
    private final byte[] vectorBytes;
    private final Double[] vectorDoubles;
    private Integer count;
    private Integer effort;
    private String filter;
    private Integer filterEffort;
    private boolean useLinearScan;
    private boolean useMainThread;

    VectorSimilarParams(String element) {
        this.element = element;
        this.vectorBytes = null;
        this.vectorDoubles = null;
    }

    VectorSimilarParams(byte[] vector) {
        this.element = null;
        this.vectorBytes = vector;
        this.vectorDoubles = null;
    }

    VectorSimilarParams(Double ... vector) {
        this.element = null;
        this.vectorBytes = null;
        this.vectorDoubles = vector;
    }

    @Override
    public VectorSimilarArgs count(int count) {
        this.count = count;
        return this;
    }

    @Override
    public VectorSimilarArgs effort(int effort) {
        this.effort = effort;
        return this;
    }

    @Override
    public VectorSimilarArgs filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public VectorSimilarArgs filterEffort(int filterEffort) {
        this.filterEffort = filterEffort;
        return this;
    }

    @Override
    public VectorSimilarArgs useLinearScan() {
        this.useLinearScan = true;
        return this;
    }

    @Override
    public VectorSimilarArgs useMainThread() {
        this.useMainThread = true;
        return this;
    }

    public String getElement() {
        return this.element;
    }

    public byte[] getVectorBytes() {
        return this.vectorBytes;
    }

    public Double[] getVectorDoubles() {
        return this.vectorDoubles;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getEffort() {
        return this.effort;
    }

    public String getFilter() {
        return this.filter;
    }

    public Integer getFilterEffort() {
        return this.filterEffort;
    }

    public boolean isUseLinearScan() {
        return this.useLinearScan;
    }

    public boolean isUseMainThread() {
        return this.useMainThread;
    }
}

