/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubStatusListener;
import org.redisson.api.NameMapper;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.listener.StatusListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.PublishSubscribeService;

public class RedissonTopic
implements RTopic {
    final PublishSubscribeService subscribeService;
    final CommandAsyncExecutor commandExecutor;
    final List<String> names = new ArrayList<String>();
    final List<ChannelName> channelNames = new ArrayList<ChannelName>();
    final Codec codec;

    public RedissonTopic(CommandAsyncExecutor commandExecutor, String ... names) {
        this(commandExecutor.getServiceManager().getCfg().getCodec(), commandExecutor, names);
    }

    public static RedissonTopic createRaw(CommandAsyncExecutor commandExecutor, String ... names) {
        return new RedissonTopic(commandExecutor.getServiceManager().getCfg().getCodec(), commandExecutor, NameMapper.direct(), names);
    }

    public static RedissonTopic createRaw(Codec codec, CommandAsyncExecutor commandExecutor, String ... names) {
        return new RedissonTopic(codec, commandExecutor, NameMapper.direct(), names);
    }

    public RedissonTopic(Codec codec, CommandAsyncExecutor commandExecutor, String ... names) {
        this(codec, commandExecutor, commandExecutor.getServiceManager().getConfig().getNameMapper(), names);
    }

    public RedissonTopic(Codec codec, CommandAsyncExecutor commandExecutor, NameMapper nameMapper, String ... names) {
        this.commandExecutor = commandExecutor;
        for (String name : names) {
            name = nameMapper.map(name);
            this.names.add(name);
            ChannelName channelName = new ChannelName(name);
            this.channelNames.add(channelName);
        }
        this.codec = commandExecutor.getServiceManager().getCodec(codec);
        this.subscribeService = commandExecutor.getConnectionManager().getSubscribeService();
    }

    @Override
    public List<String> getChannelNames() {
        return this.names;
    }

    @Override
    public long publish(Object message) {
        return this.commandExecutor.get(this.publishAsync(message));
    }

    protected String getName() {
        return this.names.get(0);
    }

    @Override
    public RFuture<Long> publishAsync(Object message) {
        String name = this.getName();
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PUBLISH, name, this.commandExecutor.encode(this.codec, message));
    }

    @Override
    public int addListener(StatusListener listener) {
        RFuture<Integer> future = this.addListenerAsync(listener);
        return (Integer)this.commandExecutor.get(future.toCompletableFuture());
    }

    @Override
    public <M> int addListener(Class<M> type, MessageListener<? extends M> listener) {
        RFuture<Integer> future = this.addListenerAsync(type, listener);
        return (Integer)this.commandExecutor.get(future.toCompletableFuture());
    }

    @Override
    public RFuture<Integer> addListenerAsync(StatusListener listener) {
        PubSubStatusListener pubSubListener = new PubSubStatusListener(listener, this.names.toArray(new String[0]));
        return this.addListenerAsync(pubSubListener);
    }

    @Override
    public <M> RFuture<Integer> addListenerAsync(Class<M> type, MessageListener<? extends M> listener) {
        PubSubMessageListener<? extends M> pubSubListener = new PubSubMessageListener<M>(type, listener, new HashSet<String>(this.names));
        return this.addListenerAsync(pubSubListener);
    }

    protected RFuture<Integer> addListenerAsync(RedisPubSubListener<?> pubSubListener) {
        CompletableFuture<List<PubSubConnectionEntry>> future = this.subscribeService.subscribe(this.codec, this.channelNames, pubSubListener);
        CompletionStage f = future.thenApply(res -> {
            Optional<RedisPubSubListener> l;
            if (pubSubListener instanceof PubSubStatusListener && this.subscribeService.isMultiEntity(this.channelNames.get(0)) && (l = res.stream().flatMap(r -> r.getListeners(this.channelNames.get(0)).stream()).filter(r -> r instanceof PubSubStatusListener && ((PubSubStatusListener)pubSubListener).getListener() == ((PubSubStatusListener)r).getListener()).findAny()).isPresent()) {
                return System.identityHashCode(l.get());
            }
            return System.identityHashCode(pubSubListener);
        });
        return new CompletableFutureWrapper<Integer>((CompletableFuture<Integer>)f);
    }

    @Override
    public void removeAllListeners() {
        this.commandExecutor.get(this.removeAllListenersAsync());
    }

    @Override
    public RFuture<Void> removeAllListenersAsync() {
        CompletableFuture<Void> f = this.subscribeService.removeAllListenersAsync(PubSubType.UNSUBSCRIBE, this.channelNames.toArray(new ChannelName[0]));
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public void removeListener(MessageListener<?> listener) {
        RFuture<Void> future = this.removeListenerAsync(listener);
        this.commandExecutor.get(future.toCompletableFuture());
    }

    @Override
    public RFuture<Void> removeListenerAsync(MessageListener<?> listener) {
        CompletableFuture<Void> f = this.subscribeService.removeListenerAsync(PubSubType.UNSUBSCRIBE, this.channelNames, listener);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Void> removeListenerAsync(Integer ... listenerIds) {
        CompletableFuture<Void> f = this.subscribeService.removeListenerAsync(PubSubType.UNSUBSCRIBE, this.channelNames, listenerIds);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public void removeListener(Integer ... listenerIds) {
        this.commandExecutor.get(this.removeListenerAsync(listenerIds).toCompletableFuture());
    }

    @Override
    public int countListeners() {
        return this.subscribeService.countListeners(this.channelNames);
    }

    @Override
    public RFuture<Long> countSubscribersAsync() {
        return this.commandExecutor.writeAsync(this.names.get(0), (Codec)LongCodec.INSTANCE, RedisCommands.PUBSUB_NUMSUB, this.names.toArray());
    }

    @Override
    public long countSubscribers() {
        return this.commandExecutor.get(this.countSubscribersAsync());
    }
}

