/*
 * Decompiled with CFR 0.152.
 */
package org.rauschig.jarchivelib;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.rauschig.jarchivelib.CommonsStreamFactory;
import org.rauschig.jarchivelib.CompressionType;
import org.rauschig.jarchivelib.Compressor;
import org.rauschig.jarchivelib.FileType;
import org.rauschig.jarchivelib.IOUtils;

class CommonsCompressor
implements Compressor {
    private final CompressionType compressionType;

    CommonsCompressor(CompressionType type) {
        this.compressionType = type;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    @Override
    public void compress(File source, File destination) throws IllegalArgumentException, IOException {
        this.assertSource(source);
        this.assertDestination(destination);
        if (destination.isDirectory()) {
            destination = new File(destination, this.getCompressedFilename(source));
        }
        CompressorOutputStream compressed = null;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(source));
            compressed = CommonsStreamFactory.createCompressorOutputStream(this, destination);
            IOUtils.copy((InputStream)input, (OutputStream)compressed);
        }
        catch (CompressorException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(compressed);
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)compressed);
        IOUtils.closeQuietly(input);
    }

    @Override
    public void decompress(File source, File destination) throws IOException {
        this.assertSource(source);
        this.assertDestination(destination);
        if (destination.isDirectory()) {
            destination = new File(destination, this.getDecompressedFilename(source));
        }
        CompressorInputStream compressed = null;
        FileOutputStream output = null;
        try {
            compressed = CommonsStreamFactory.createCompressorInputStream(this.getCompressionType(), source);
            output = new FileOutputStream(destination);
            IOUtils.copy((InputStream)compressed, output);
        }
        catch (CompressorException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(compressed);
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)compressed);
        IOUtils.closeQuietly(output);
    }

    @Override
    public InputStream decompressingStream(InputStream compressedStream) throws IOException {
        try {
            return CommonsStreamFactory.createCompressorInputStream(this.getCompressionType(), compressedStream);
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getFilenameExtension() {
        return this.getCompressionType().getDefaultFileExtension();
    }

    private String getCompressedFilename(File source) {
        return source.getName() + this.getFilenameExtension();
    }

    private String getDecompressedFilename(File source) {
        FileType fileType = FileType.get(source);
        if (this.compressionType != fileType.getCompressionType()) {
            throw new IllegalArgumentException(source + " is not of type " + (Object)((Object)this.compressionType));
        }
        return source.getName().substring(0, source.getName().length() - fileType.getSuffix().length());
    }

    private void assertSource(File source) throws IllegalArgumentException, FileNotFoundException {
        if (source == null) {
            throw new IllegalArgumentException("Source is null");
        }
        if (source.isDirectory()) {
            throw new IllegalArgumentException("Source " + source + " is a directory.");
        }
        if (!source.exists()) {
            throw new FileNotFoundException(source.getName());
        }
        if (!source.canRead()) {
            throw new IllegalArgumentException("Can not read from source " + source);
        }
    }

    private void assertDestination(File destination) {
        if (destination == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (destination.isDirectory() ? !destination.canWrite() : destination.exists() && !destination.canWrite()) {
            throw new IllegalArgumentException("Can not write to destination " + destination);
        }
    }
}

